/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.transform;

import com.dianping.cat.consumer.storage.model.entity.Machine;
import com.dianping.cat.consumer.storage.model.entity.Operation;
import com.dianping.cat.consumer.storage.model.transform.BaseVisitor;
import com.dianping.cat.report.graph.PieChart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PieChartVisitor
extends BaseVisitor {
    private String m_ip;
    private Map<String, Long> m_items = new HashMap();

    public String getPiechartJson() {
        if (this.m_items.size() > 0) {
            PieChart chart = new PieChart();
            ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
            for (Map.Entry entry : this.m_items.entrySet()) {
                PieChart.Item item = new PieChart.Item();
                item.setNumber((double)((Long)entry.getValue()).longValue()).setTitle((String)entry.getKey());
                items.add(item);
            }
            chart.addItems(items);
            return chart.getJsonString();
        }
        return null;
    }

    public void visitMachine(Machine machine) {
        this.m_ip = machine.getId();
        super.visitMachine(machine);
    }

    public void visitOperation(Operation operation) {
        long errors = operation.getError();
        if (errors > 0L) {
            Long item = (Long)this.m_items.get(this.m_ip);
            if (item == null) {
                this.m_items.put(this.m_ip, errors);
            } else {
                this.m_items.put(this.m_ip, item + errors);
            }
        }
    }
}

