/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.top;

import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.entity.Segment;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.report.page.top.DomainInfo;
import java.text.SimpleDateFormat;

public class ProblemReportVisitor
extends BaseVisitor {
    private DomainInfo m_info;
    private String m_ipAddress;
    private String m_type;
    private String m_date;
    private Integer m_minute;

    public ProblemReportVisitor(String ipAddress, DomainInfo info, String type) {
        this.m_info = info;
        this.m_type = type;
        this.m_ipAddress = ipAddress;
    }

    public void visitProblemReport(ProblemReport problemReport) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:");
        this.m_date = sdf.format(problemReport.getStartTime());
        super.visitProblemReport(problemReport);
    }

    public void visitMachine(Machine machine) {
        String id = machine.getIp();
        if ("All".equals(this.m_ipAddress) || id.equals(this.m_ipAddress)) {
            super.visitMachine(machine);
        }
    }

    public void visitEntity(Entity entity) {
        if (this.m_type.equals(entity.getType())) {
            super.visitEntity(entity);
        }
    }

    public void visitSegment(Segment segment) {
        this.m_minute = segment.getId();
        int count = segment.getCount();
        String key = "";
        key = this.m_minute >= 10 ? this.m_date + this.m_minute : this.m_date + '0' + this.m_minute;
        DomainInfo.Metric metric = this.m_info.getMetric(key);
        metric.addException(count);
    }
}

