/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.top;

import com.dianping.cat.consumer.top.model.entity.Domain;
import com.dianping.cat.consumer.top.model.entity.Error;
import com.dianping.cat.consumer.top.model.entity.Segment;
import com.dianping.cat.consumer.top.model.transform.BaseVisitor;
import com.dianping.cat.report.alert.exception.ExceptionRuleConfigManager;
import java.util.ArrayList;
import java.util.List;

public class TopExceptionExclude
extends BaseVisitor {
    private ExceptionRuleConfigManager m_configManager;
    private String m_domain;
    private Segment m_segment;
    private List<String> m_exceptions = new ArrayList();

    public TopExceptionExclude(ExceptionRuleConfigManager configManager) {
        this.m_configManager = configManager;
    }

    public void visitDomain(Domain domain) {
        this.m_domain = domain.getName();
        super.visitDomain(domain);
    }

    public void visitError(Error error) {
        String exception = error.getId();
        boolean isExcluded = this.m_configManager.isExcluded(this.m_domain, exception);
        if (isExcluded) {
            this.m_segment.setError(this.m_segment.getError() - (long)error.getCount());
            this.m_exceptions.add(exception);
        } else {
            super.visitError(error);
        }
    }

    public void visitSegment(Segment segment) {
        this.m_segment = segment;
        this.m_exceptions.clear();
        super.visitSegment(segment);
        for (String exception : this.m_exceptions) {
            segment.removeError(exception);
        }
    }
}

