/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.top.service;

import com.dianping.cat.consumer.top.TopReportMerger;
import com.dianping.cat.consumer.top.model.IEntity;
import com.dianping.cat.consumer.top.model.IVisitor;
import com.dianping.cat.consumer.top.model.entity.TopReport;
import com.dianping.cat.consumer.top.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.top.service.LocalTopService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=LocalModelService.class, value="top")
public class LocalTopService
extends LocalModelService<TopReport> {
    public static final String ID = "top";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalTopService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        long startTime;
        List reports = super.getReport(period, domain);
        TopReport report = null;
        if (reports != null) {
            report = new TopReport(domain);
            TopReportMerger merger = new TopReportMerger(report);
            for (TopReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getDomains().isEmpty()) && period.isLast() && (report = this.getReportFromLocalDisk(startTime = request.getStartTime(), domain)) == null) {
            report = new TopReport(domain);
            report.setStartTime(new Date(startTime));
            report.setEndTime(new Date(startTime + 3600000L - 1L));
        }
        return new TopReportFilter().buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        TopReport report = new TopReport(domain);
        TopReportMerger merger = new TopReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml == null) continue;
                TopReport tmp = DefaultSaxParser.parse((String)xml);
                tmp.accept((IVisitor)merger);
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

