/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.top.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.top.TopReportMerger;
import com.dianping.cat.consumer.top.model.IVisitor;
import com.dianping.cat.consumer.top.model.entity.TopReport;
import com.dianping.cat.consumer.top.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class TopReportService
extends AbstractReportService<TopReport> {
    public TopReport makeReport(String domain, Date start, Date end) {
        TopReport report = new TopReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public TopReport queryDailyReport(String domain, Date start, Date end) {
        throw new RuntimeException("Top report don't support daily report");
    }

    private TopReport queryFromHourlyBinary(int id, Date period, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, period, HourlyReportContentEntity.READSET_CONTENT);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TopReport(domain);
    }

    public TopReport queryHourlyReport(String domain, Date start, Date end) {
        TopReportMerger merger = new TopReportMerger(new TopReport(domain));
        long endTime = end.getTime();
        String name = "top";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    TopReport reportModel = this.queryFromHourlyBinary(report.getId(), report.getPeriod(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        TopReport topReport = merger.getTopReport();
        topReport.setStartTime(start);
        topReport.setEndTime(new Date(end.getTime() - 1L));
        return topReport;
    }

    public TopReport queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("Top report don't support monthly report");
    }

    public TopReport queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("Top report don't support weekly report");
    }
}

