/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.task;

import com.dianping.cat.Cat;
import com.dianping.cat.config.AtomicMessageConfigManager;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.transaction.TransactionReportCountFilter;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.task.HistoryTransactionReportMerger;
import com.dianping.cat.report.page.transaction.task.TransactionReportDailyGraphCreator;
import com.dianping.cat.report.page.transaction.task.TransactionReportHourlyGraphCreator;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import java.util.Date;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="transaction")
public class TransactionReportBuilder
implements Initializable,
TaskBuilder,
LogEnabled {
    public static final String ID = "transaction";
    @Inject
    protected TransactionReportService m_reportService;
    @Inject
    protected ServerConfigManager m_serverConfigManager;
    @Inject
    private AtomicMessageConfigManager m_atomicMessageConfigManager;
    private Logger m_logger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            Date end = TaskHelper.tomorrowZero((Date)period);
            TransactionReport transactionReport = this.queryHourlyReportsByDuration(name, domain, period, end);
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((TransactionReport)transactionReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("transaction report don't support HourlyReport!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentMonth()) ? TimeHelper.getCurrentDay() : TaskHelper.nextMonthStart((Date)period);
        TransactionReport transactionReport = this.queryDailyReportsByDuration(domain, period, end);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((TransactionReport)transactionReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentWeek()) ? TimeHelper.getCurrentDay() : new Date(period.getTime() + 604800000L);
        TransactionReport transactionReport = this.queryDailyReportsByDuration(domain, period, end);
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((TransactionReport)transactionReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void initialize() throws InitializationException {
        CurrentWeeklyMonthlyReportTask.getInstance().register((CurrentWeeklyMonthlyReportTask.CurrentWeeklyMonthlyTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    private TransactionReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        double duration = (double)(end.getTime() - start.getTime()) * 1.0 / 8.64E7;
        HistoryTransactionReportMerger merger = new HistoryTransactionReportMerger(new TransactionReport(domain)).setDuration(duration);
        TransactionReport transactionReport = merger.getTransactionReport();
        TransactionReportDailyGraphCreator creator = new TransactionReportDailyGraphCreator(transactionReport, (int)duration, start);
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                TransactionReport reportModel = (TransactionReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                creator.createGraph(reportModel);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        transactionReport.setStartTime(start);
        transactionReport.setEndTime(end);
        new TransactionReportCountFilter(this.m_serverConfigManager.getMaxTypeThreshold(), this.m_atomicMessageConfigManager.getMaxNameThreshold(domain), this.m_serverConfigManager.getTypeNameLengthLimit()).visitTransactionReport(transactionReport);
        return transactionReport;
    }

    private TransactionReport queryHourlyReportsByDuration(String name, String domain, Date start, Date endDate) throws DalException {
        long startTime;
        long endTime = endDate.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        HistoryTransactionReportMerger dailyMerger = new HistoryTransactionReportMerger(new TransactionReport(domain)).setDuration(duration);
        TransactionReportHourlyGraphCreator graphCreator = new TransactionReportHourlyGraphCreator(dailyMerger.getTransactionReport(), 10);
        for (startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            graphCreator.createGraph(report);
            report.accept((IVisitor)dailyMerger);
        }
        TransactionReport dailyreport = dailyMerger.getTransactionReport();
        Date date = dailyreport.getStartTime();
        Date end = new Date(TaskHelper.tomorrowZero((Date)date).getTime() - 1000L);
        dailyreport.setStartTime(TaskHelper.todayZero((Date)date));
        dailyreport.setEndTime(end);
        new TransactionReportCountFilter(this.m_serverConfigManager.getMaxTypeThreshold(), this.m_atomicMessageConfigManager.getMaxNameThreshold(domain), this.m_serverConfigManager.getTypeNameLengthLimit()).visitTransactionReport(dailyreport);
        return dailyreport;
    }
}

