/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task;

import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.report.server.ServersUpdater;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.report.task.DefaultRemoteServersUpdater;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ServersUpdater.class)
public class DefaultRemoteServersUpdater
implements ServersUpdater {
    @Inject(type=ModelService.class, value={"state"})
    private ModelService<StateReport> m_service;

    public Map<String, Set<String>> buildServers(Date hour) {
        StateReport currentReport = this.queryStateReport("cat", hour.getTime());
        StateReportVisitor visitor = new StateReportVisitor();
        visitor.visitStateReport(currentReport);
        return visitor.getServers();
    }

    public StateReport queryStateReport(String domain, long time) {
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period == ModelPeriod.CURRENT || period == ModelPeriod.LAST) {
            ModelRequest request = new ModelRequest(domain, time);
            if (this.m_service.isEligable(request)) {
                ModelResponse response = this.m_service.invoke(request);
                StateReport report = (StateReport)response.getModel();
                return report;
            }
            throw new RuntimeException("Internal error: no eligable state report service registered for " + request + "!");
        }
        throw new RuntimeException("Domain server update period is not right: " + period + ", time is: " + new Date(time));
    }
}

