/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.cmdb;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.core.dal.Hostinfo;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.service.HostinfoService;
import com.dianping.cat.service.ProjectService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalException;
import org.unidal.helper.Files;
import org.unidal.helper.Threads;
import org.unidal.helper.Urls;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.util.StringUtils;
import org.unidal.webres.json.JsonArray;
import org.unidal.webres.json.JsonObject;

@Named
public class ProjectUpdateTask
implements Threads.Task,
LogEnabled {
    private static final String CMDB_DOMAIN_URL = "http://api.cmdb.dp/api/v0.1/projects/s?private_ip=%s";
    private static final String CMDB_INFO_URL = "http://api.cmdb.dp/api/v0.1/projects/%s";
    private static final String CMDB_BU_URL = "http://api.cmdb.dp/api/v0.1/projects/%s/bu";
    private static final String CMDB_PRODUCT_URL = "http://api.cmdb.dp/api/v0.1/projects/%s/product";
    private static final String CMDB_HOSTNAME_URL = "http://api.cmdb.dp/api/v0.1/ci/s?q=_type:(vserver;server;tx-vserver),private_ip:%s&fl=hostname";
    protected Logger m_logger;
    @Inject
    private HostinfoService m_hostInfoService;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private TransactionReportService m_reportService;

    private boolean checkIfNullOrEqual(String source, int target) {
        if (source == null || source.equals("null")) {
            return true;
        }
        return Integer.parseInt(source) == target;
    }

    private boolean checkIfNullOrEqual(String source, String target) {
        if (source == null || source.equals("null")) {
            return true;
        }
        return source.equals(target);
    }

    private boolean checkIfValid(String source) {
        return source != null && !"".equals(source) && !"null".equals(source);
    }

    public void deleteUnusedDomainInfo() {
        try {
            List all = this.m_projectService.findAll();
            Date start = TimeHelper.getCurrentDay((int)-30);
            Date end = TimeHelper.getCurrentDay();
            Set domainNames = this.m_reportService.queryAllDomainNames(start, end, "transaction");
            ArrayList<Project> toRemoves = new ArrayList<Project>();
            for (Project project : all) {
                String name = project.getDomain();
                if (domainNames.contains(name)) continue;
                toRemoves.add(project);
            }
            for (Project project : toRemoves) {
                this.m_projectService.delete(project);
                Cat.logEvent((String)"DeleteDomainInfo", (String)project.getDomain(), (String)"0", (String)project.toString());
            }
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public String getName() {
        return "product_update_task";
    }

    public String parseDomain(String content) throws Exception {
        JsonObject object = new JsonObject(content);
        JsonArray projectArray = object.getJSONArray("projects");
        if (projectArray.length() > 0) {
            JsonObject firstProject = projectArray.getJSONObject(0);
            return firstProject.get("project_name").toString();
        }
        return null;
    }

    public String parseHostname(String content) throws Exception {
        JsonObject object = new JsonObject(content);
        JsonArray resultArray = object.getJSONArray("result");
        if (resultArray.length() > 0) {
            JsonObject firstResult = resultArray.getJSONObject(0);
            return firstResult.get("hostname").toString();
        }
        return null;
    }

    private String parseInfo(String content, String jsonName, String attrName) throws Exception {
        Object obj;
        JsonObject json = new JsonObject(content).getJSONObject(jsonName);
        if (json != null && (obj = json.get(attrName)) != null) {
            return obj.toString();
        }
        return null;
    }

    private Map<String, String> parseInfos(String content) throws Exception {
        HashMap<String, String> infosMap = new HashMap<String, String>();
        JsonObject project = new JsonObject(content).getJSONObject("project");
        if (project == null) {
            return infosMap;
        }
        Object owner = project.get("rd_duty");
        Object email = project.get("project_email");
        Object phone = project.get("rd_mobile");
        Object level = project.get("project_level");
        if (email != null) {
            infosMap.put("owner", owner.toString());
        } else {
            infosMap.put("owner", null);
        }
        if (email != null) {
            infosMap.put("email", email.toString());
        } else {
            infosMap.put("email", null);
        }
        if (phone != null) {
            infosMap.put("phone", phone.toString());
        } else {
            infosMap.put("phone", null);
        }
        if (level != null) {
            infosMap.put("level", level.toString());
        } else {
            infosMap.put("level", null);
        }
        return infosMap;
    }

    private String queryCmdbName(List<String> ips) {
        HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
        for (String ip : ips) {
            String cmdbDomain = this.queryDomainFromCMDB(ip);
            if (!this.checkIfValid(cmdbDomain)) continue;
            Integer count = (Integer)nameCountMap.get(cmdbDomain);
            if (count == null) {
                nameCountMap.put(cmdbDomain, 1);
                continue;
            }
            nameCountMap.put(cmdbDomain, count + 1);
        }
        String probableDomain = null;
        int maxCount = 0;
        for (Map.Entry entry : nameCountMap.entrySet()) {
            int currentCount = (Integer)entry.getValue();
            if (currentCount <= maxCount) continue;
            maxCount = currentCount;
            probableDomain = (String)entry.getKey();
        }
        return probableDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryDomainFromCMDB(String ip) {
        Transaction t = Cat.newTransaction((String)"CMDB", (String)"queryDomain");
        try {
            String cmdb = String.format(CMDB_DOMAIN_URL, ip);
            InputStream in = Urls.forIO().readTimeout(1000).connectTimeout(1000).openStream(cmdb);
            String content = Files.forIO().readFrom(in, "utf-8");
            t.setStatus("0");
            t.addData(content);
            String string = this.parseDomain(content.trim());
            return string;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryHostnameFromCMDB(String ip) {
        Transaction t = Cat.newTransaction((String)"CMDB", (String)"queryHostname");
        try {
            String cmdb = String.format(CMDB_HOSTNAME_URL, ip);
            InputStream in = Urls.forIO().readTimeout(1000).connectTimeout(1000).openStream(cmdb);
            String content = Files.forIO().readFrom(in, "utf-8");
            t.setStatus("0");
            t.addData(content);
            String string = this.parseHostname(content.trim());
            return string;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
        return null;
    }

    private List<String> queryIpsFromReport(String domain) {
        Date startDate = TimeHelper.getCurrentDay((int)-2);
        Date endDate = TimeHelper.getCurrentDay();
        TransactionReport report = this.m_reportService.queryDailyReport(domain, startDate, endDate);
        Set ipSet = report.getMachines().keySet();
        ArrayList<String> ipList = new ArrayList<String>();
        ipList.addAll(ipSet);
        return ipList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> queryProjectInfoFromCMDB(String cmdbDomain) {
        Transaction t = Cat.newTransaction((String)"CMDB", (String)"queryProjectInfo");
        try {
            String cmdb = String.format(CMDB_INFO_URL, cmdbDomain);
            InputStream in = Urls.forIO().readTimeout(1000).connectTimeout(1000).openStream(cmdb);
            String content = Files.forIO().readFrom(in, "utf-8");
            t.setStatus("0");
            t.addData(content);
            Map map = this.parseInfos(content.trim());
            return map;
        }
        catch (Exception exception) {
        }
        finally {
            t.complete();
        }
        return new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryProjectInfoFromCMDB(String url, String jsonName, String attrName) {
        Transaction t = Cat.newTransaction((String)"CMDB", (String)"queryProjectInfo");
        try {
            InputStream in = Urls.forIO().readTimeout(1000).connectTimeout(1000).openStream(url);
            String content = Files.forIO().readFrom(in, "utf-8");
            t.setStatus("0");
            t.addData(content);
            String string = this.parseInfo(content, jsonName, attrName);
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            t.complete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Transaction t2 = Cat.newTransaction((String)"CMDB", (String)"UpdateHostname");
        try {
            this.updateHostNameInfo();
            t2.setStatus("0");
        }
        catch (Exception e) {
            t2.setStatus((Throwable)e);
        }
        finally {
            t2.complete();
        }
        Transaction t3 = Cat.newTransaction((String)"CMDB", (String)"UpdateProjectInfo");
        try {
            this.updateProjectInfo();
            t3.setStatus("0");
        }
        catch (Exception e) {
            t3.setStatus((Throwable)e);
        }
        finally {
            t3.complete();
        }
    }

    public void shutdown() {
    }

    private void updateHostNameInfo() {
        try {
            List infos = this.m_hostInfoService.findAll();
            for (Hostinfo info : infos) {
                try {
                    String hostname = info.getHostname();
                    String ip = info.getIp();
                    String cmdbHostname = this.queryHostnameFromCMDB(ip);
                    if (StringUtils.isEmpty((String)cmdbHostname) || !StringUtils.isEmpty((String)hostname) && hostname.equals(cmdbHostname)) continue;
                    info.setHostname(cmdbHostname);
                    this.m_hostInfoService.updateHostinfo(info);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
        }
    }

    private boolean updateProject(Project pro) {
        String cmdbDomain = pro.getCmdbDomain();
        Map infosMap = this.queryProjectInfoFromCMDB(cmdbDomain);
        String cmdbOwner = (String)infosMap.get("owner");
        String cmdbEmail = (String)infosMap.get("email");
        String cmdbPhone = (String)infosMap.get("phone");
        String cmdbLevel = (String)infosMap.get("level");
        String dbOwner = pro.getOwner();
        String dbEmail = pro.getEmail();
        String dbPhone = pro.getPhone();
        int dbLevel = pro.getLevel();
        boolean isProjChanged = false;
        if (!this.checkIfNullOrEqual(cmdbOwner, dbOwner)) {
            pro.setOwner(cmdbOwner);
            isProjChanged = true;
        }
        if (!this.checkIfNullOrEqual(cmdbEmail, dbEmail)) {
            pro.setEmail(cmdbEmail);
            isProjChanged = true;
        }
        if (!this.checkIfNullOrEqual(cmdbPhone, dbPhone)) {
            pro.setPhone(cmdbPhone);
            isProjChanged = true;
        }
        if (!this.checkIfNullOrEqual(cmdbLevel, dbLevel)) {
            pro.setLevel(Integer.parseInt(cmdbLevel));
            isProjChanged = true;
        }
        String buUrl = String.format(CMDB_BU_URL, cmdbDomain);
        String productlineUrl = String.format(CMDB_PRODUCT_URL, cmdbDomain);
        String cmdbBu = this.queryProjectInfoFromCMDB(buUrl, "bu", "bu_name");
        String cmdbProductline = this.queryProjectInfoFromCMDB(productlineUrl, "product", "product_name");
        String dbBu = pro.getBu();
        String dbProductline = pro.getCmdbProductline();
        if (!this.checkIfNullOrEqual(cmdbBu, dbBu)) {
            pro.setBu(cmdbBu);
            isProjChanged = true;
        }
        if (!this.checkIfNullOrEqual(cmdbProductline, dbProductline)) {
            pro.setCmdbProductline(cmdbProductline);
            isProjChanged = true;
        }
        return isProjChanged;
    }

    private void updateProjectInfo() {
        try {
            List projects = this.m_projectService.findAll();
            for (Project pro : projects) {
                try {
                    String cmdbDomain = pro.getCmdbDomain();
                    if (StringUtils.isEmpty((String)cmdbDomain)) {
                        List ips = this.queryIpsFromReport(pro.getDomain());
                        cmdbDomain = this.queryCmdbName(ips);
                    }
                    if (!StringUtils.isNotEmpty((String)cmdbDomain)) continue;
                    boolean isChange = !cmdbDomain.equals(pro.getCmdbDomain());
                    pro.setCmdbDomain(cmdbDomain);
                    boolean isProjectInfoChange = this.updateProject(pro);
                    if (!isProjectInfoChange && !isChange) continue;
                    this.m_projectService.update(pro);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
        }
    }
}

