/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.current;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import com.dianping.cat.service.ProjectService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="currentReport")
public class CurrentReportBuilder
implements TaskBuilder {
    public static final String ID = "currentReport";
    @Inject
    private ProjectService m_projectService;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;

    public boolean buildDailyTask(String name, String domain, Date period) {
        CurrentWeeklyMonthlyReportTask reportTask = CurrentWeeklyMonthlyReportTask.getInstance();
        try {
            List projects = this.m_projectService.findAll();
            ArrayList<String> domains = new ArrayList<String>();
            for (Project project : projects) {
                if (!this.m_serverFilterConfigManager.validateDomain(project.getDomain())) continue;
                domains.add(project.getDomain());
            }
            reportTask.setDomains(domains);
            Threads.forGroup((String)"cat").start((Runnable)reportTask);
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
        return true;
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("current weekly monthly report builder don't support hourly task");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("current weekly monthly report builder don't support monthly task");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("current weekly monthly report builder don't support weekly task");
    }
}

