/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.current;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import java.util.ArrayList;
import java.util.List;
import org.unidal.helper.Threads;

public class CurrentWeeklyMonthlyReportTask
implements Threads.Task {
    private static CurrentWeeklyMonthlyReportTask m_instance = new CurrentWeeklyMonthlyReportTask();
    private List<CurrentWeeklyMonthlyTask> m_tasks = new ArrayList();
    private List<String> m_domains;

    public static CurrentWeeklyMonthlyReportTask getInstance() {
        return m_instance;
    }

    public String getName() {
        return "Cached-Report-Task";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CurrentWeeklyMonthlyTask handler) {
        CurrentWeeklyMonthlyReportTask currentWeeklyMonthlyReportTask = this;
        synchronized (currentWeeklyMonthlyReportTask) {
            this.m_tasks.add(handler);
        }
    }

    private void reloadCurrentMonthly() {
        for (String domain : this.m_domains) {
            Transaction t = Cat.newTransaction((String)"ReloadTask", (String)("Reload-Month-" + domain));
            for (CurrentWeeklyMonthlyTask task : this.m_tasks) {
                try {
                    task.buildCurrentMonthlyTask(task.getReportName(), domain, TimeHelper.getCurrentMonth());
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
            t.setStatus("0");
            t.complete();
        }
    }

    private void reloadCurrentWeekly() {
        for (String domain : this.m_domains) {
            Transaction t = Cat.newTransaction((String)"ReloadTask", (String)("Reload-Week-" + domain));
            for (CurrentWeeklyMonthlyTask task : this.m_tasks) {
                task.buildCurrentWeeklyTask(task.getReportName(), domain, TimeHelper.getCurrentWeek());
            }
            t.setStatus("0");
            t.complete();
        }
    }

    public void run() {
        this.reloadCurrentWeekly();
        this.reloadCurrentMonthly();
    }

    public void setDomains(List<String> domains) {
        this.m_domains = domains;
    }

    public void shutdown() {
    }
}

