/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.cross.CrossReportMerger;
import com.dianping.cat.consumer.cross.model.IVisitor;
import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.cross.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="cross")
public class CrossReportReloader
extends AbstractReportReloader {
    @Inject(value={"cross"})
    protected ReportManager<CrossReport> m_reportManager;

    private List<CrossReport> buildMergedReports(Map<String, List<CrossReport>> mergedReports) {
        ArrayList<CrossReport> results = new ArrayList<CrossReport>();
        for (Map.Entry<String, List<CrossReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            CrossReport report = new CrossReport(domain);
            CrossReportMerger merger = new CrossReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (CrossReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getCrossReport());
        }
        return results;
    }

    public String getId() {
        return "cross";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<CrossReport>> mergedReports = new HashMap<String, ArrayList<CrossReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                CrossReport r = (CrossReport)entry.getValue();
                ArrayList<CrossReport> rs = (ArrayList<CrossReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<CrossReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (CrossReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((CrossReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

