/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.heartbeat.HeartbeatReportMerger;
import com.dianping.cat.consumer.heartbeat.model.IVisitor;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="heartbeat")
public class HeartbeatReportReloader
extends AbstractReportReloader {
    @Inject(value={"heartbeat"})
    protected ReportManager<HeartbeatReport> m_reportManager;

    private List<HeartbeatReport> buildMergedReports(Map<String, List<HeartbeatReport>> mergedReports) {
        ArrayList<HeartbeatReport> results = new ArrayList<HeartbeatReport>();
        for (Map.Entry<String, List<HeartbeatReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            HeartbeatReport report = new HeartbeatReport(domain);
            HeartbeatReportMerger merger = new HeartbeatReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (HeartbeatReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getHeartbeatReport());
        }
        return results;
    }

    public String getId() {
        return "heartbeat";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<HeartbeatReport>> mergedReports = new HashMap<String, ArrayList<HeartbeatReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                HeartbeatReport r = (HeartbeatReport)entry.getValue();
                ArrayList<HeartbeatReport> rs = (ArrayList<HeartbeatReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<HeartbeatReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (HeartbeatReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((HeartbeatReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

