/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.matrix.MatrixReportMerger;
import com.dianping.cat.consumer.matrix.model.IVisitor;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.consumer.matrix.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="matrix")
public class MatrixReportReloader
extends AbstractReportReloader {
    @Inject(value={"matrix"})
    protected ReportManager<MatrixReport> m_reportManager;

    private List<MatrixReport> buildMergedReports(Map<String, List<MatrixReport>> mergedReports) {
        ArrayList<MatrixReport> results = new ArrayList<MatrixReport>();
        for (Map.Entry<String, List<MatrixReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            MatrixReport report = new MatrixReport(domain);
            MatrixReportMerger merger = new MatrixReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (MatrixReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getMatrixReport());
        }
        return results;
    }

    public String getId() {
        return "matrix";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<MatrixReport>> mergedReports = new HashMap<String, ArrayList<MatrixReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                MatrixReport r = (MatrixReport)entry.getValue();
                ArrayList<MatrixReport> rs = (ArrayList<MatrixReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<MatrixReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (MatrixReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((MatrixReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

