/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.state.StateReportMerger;
import com.dianping.cat.consumer.state.model.IVisitor;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.consumer.state.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="state")
public class StateReportReloader
extends AbstractReportReloader {
    @Inject(value={"state"})
    protected ReportManager<StateReport> m_reportManager;

    private List<StateReport> buildMergedReports(Map<String, List<StateReport>> mergedReports) {
        ArrayList<StateReport> results = new ArrayList<StateReport>();
        for (Map.Entry<String, List<StateReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            StateReport report = new StateReport(domain);
            StateReportMerger merger = new StateReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (StateReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getStateReport());
        }
        return results;
    }

    public String getId() {
        return "state";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<StateReport>> mergedReports = new HashMap<String, ArrayList<StateReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                StateReport r = (StateReport)entry.getValue();
                ArrayList<StateReport> rs = (ArrayList<StateReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<StateReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (StateReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((StateReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

