/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.storage.StorageReportMerger;
import com.dianping.cat.consumer.storage.model.IVisitor;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="storage")
public class StorageReportReloader
extends AbstractReportReloader {
    @Inject(value={"storage"})
    protected ReportManager<StorageReport> m_reportManager;

    private List<StorageReport> buildMergedReports(Map<String, List<StorageReport>> mergedReports) {
        ArrayList<StorageReport> results = new ArrayList<StorageReport>();
        for (Map.Entry<String, List<StorageReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            StorageReport report = new StorageReport(domain);
            StorageReportMerger merger = new StorageReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (StorageReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getStorageReport());
        }
        return results;
    }

    public String getId() {
        return "storage";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<StorageReport>> mergedReports = new HashMap<String, ArrayList<StorageReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                StorageReport r = (StorageReport)entry.getValue();
                ArrayList<StorageReport> rs = (ArrayList<StorageReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<StorageReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (StorageReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getId());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((StorageReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

