/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.top.TopReportMerger;
import com.dianping.cat.consumer.top.model.IVisitor;
import com.dianping.cat.consumer.top.model.entity.TopReport;
import com.dianping.cat.consumer.top.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="top")
public class TopReportReloader
extends AbstractReportReloader {
    @Inject(value={"top"})
    protected ReportManager<TopReport> m_reportManager;

    private List<TopReport> buildMergedReports(Map<String, List<TopReport>> mergedReports) {
        ArrayList<TopReport> results = new ArrayList<TopReport>();
        for (Map.Entry<String, List<TopReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            TopReport report = new TopReport(domain);
            TopReportMerger merger = new TopReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (TopReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getTopReport());
        }
        return results;
    }

    public String getId() {
        return "top";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<TopReport>> mergedReports = new HashMap<String, ArrayList<TopReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                TopReport r = (TopReport)entry.getValue();
                ArrayList<TopReport> rs = (ArrayList<TopReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<TopReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (TopReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((TopReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

