/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.business.config;

import com.dianping.cat.Cat;
import com.dianping.cat.core.config.BusinessConfig;
import com.dianping.cat.core.config.BusinessConfigDao;
import com.dianping.cat.core.config.BusinessConfigEntity;
import com.dianping.cat.home.business.entity.BusinessItem;
import com.dianping.cat.home.business.entity.BusinessTagConfig;
import com.dianping.cat.home.business.entity.Tag;
import com.dianping.cat.home.business.transform.DefaultSaxParser;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Inject;

public class BusinessTagConfigManager
implements Initializable {
    public static final String TAG_CONFIG = "tag";
    @Inject
    private BusinessConfigDao m_configDao;
    private int m_configId;
    private BusinessTagConfig m_tagConfig;

    public Set<String> findAllTags() {
        return this.m_tagConfig.getTags().keySet();
    }

    public Tag findTag(String id) {
        return this.m_tagConfig.findTag(id);
    }

    public Map<String, Set<String>> findTagByDomain(String domain) {
        HashMap<String, Set<String>> domainTags = new HashMap<String, Set<String>>();
        Map tags = this.m_tagConfig.getTags();
        for (Tag tag : tags.values()) {
            List items = tag.getBusinessItems();
            for (BusinessItem item : items) {
                if (!item.getDomain().equals(domain)) continue;
                String id = item.getItemId();
                HashSet<String> itemTags = (HashSet<String>)domainTags.get(id);
                if (itemTags == null) {
                    itemTags = new HashSet<String>();
                    domainTags.put(id, itemTags);
                }
                itemTags.add(tag.getId());
            }
        }
        return domainTags;
    }

    public BusinessTagConfig getConfig() {
        return this.m_tagConfig;
    }

    public void initialize() throws InitializationException {
        try {
            List result = this.m_configDao.findByName(TAG_CONFIG, BusinessConfigEntity.READSET_FULL);
            if (result.size() > 0) {
                BusinessConfig config = (BusinessConfig)result.get(0);
                this.m_configId = config.getId();
                this.m_tagConfig = DefaultSaxParser.parse((String)config.getContent());
            } else {
                this.m_tagConfig = new BusinessTagConfig();
                BusinessConfig config = this.m_configDao.createLocal();
                config.setName(TAG_CONFIG);
                config.setDomain("cat");
                config.setContent(this.m_tagConfig.toString());
                config.setUpdatetime(new Date());
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public boolean store(String xml) {
        try {
            this.m_tagConfig = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        BusinessTagConfigManager businessTagConfigManager = this;
        synchronized (businessTagConfigManager) {
            try {
                BusinessConfig config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(TAG_CONFIG);
                config.setContent(this.m_tagConfig.toString());
                config.setUpdatetime(new Date());
                this.m_configDao.updateByPK(config, BusinessConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

