/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.home.dal.report.ConfigModification;
import com.dianping.cat.home.dal.report.ConfigModificationDao;
import com.dianping.cat.system.SystemPage;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.Context;
import com.dianping.cat.system.page.config.Handler;
import com.dianping.cat.system.page.config.JspViewer;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.AlertConfigProcessor;
import com.dianping.cat.system.page.config.processor.DependencyConfigProcessor;
import com.dianping.cat.system.page.config.processor.EventConfigProcessor;
import com.dianping.cat.system.page.config.processor.ExceptionConfigProcessor;
import com.dianping.cat.system.page.config.processor.GlobalConfigProcessor;
import com.dianping.cat.system.page.config.processor.HeartbeatConfigProcessor;
import com.dianping.cat.system.page.config.processor.StorageConfigProcessor;
import com.dianping.cat.system.page.config.processor.TransactionConfigProcessor;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;
import org.unidal.web.mvc.annotation.PreInboundActionMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private GlobalConfigProcessor m_globalConfigProcessor;
    @Inject
    private DependencyConfigProcessor m_topologyConfigProcessor;
    @Inject
    private ExceptionConfigProcessor m_exceptionConfigProcessor;
    @Inject
    private HeartbeatConfigProcessor m_heartbeatConfigProcessor;
    @Inject
    private AlertConfigProcessor m_alertConfigProcessor;
    @Inject
    private TransactionConfigProcessor m_transactionConfigProcessor;
    @Inject
    private EventConfigProcessor m_eventConfigProcessor;
    @Inject
    private StorageConfigProcessor m_storageConfigProcessor;
    @Inject
    private ConfigModificationDao m_configModificationDao;

    @PreInboundActionMeta(value={"login"})
    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="config")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @PreInboundActionMeta(value={"login"})
    @OutboundActionMeta(name="config")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        model.setPage((Page)SystemPage.CONFIG);
        Action action = payload.getAction();
        this.storeModifyInfo(ctx, payload);
        model.setAction((org.unidal.web.mvc.Action)action);
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.m_globalConfigProcessor.process(action, payload, model);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_topologyConfigProcessor.process(action, payload, model);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.m_exceptionConfigProcessor.process(action, payload, model);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.m_heartbeatConfigProcessor.process(action, payload, model);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                this.m_storageConfigProcessor.process(action, payload, model);
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.m_transactionConfigProcessor.process(action, payload, model);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.m_eventConfigProcessor.process(action, payload, model);
                break;
            }
            case 51: 
            case 52: {
                this.m_alertConfigProcessor.process(action, payload, model);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    public void store(String userName, String accountName, Payload payload) {
        ConfigModification modification = this.m_configModificationDao.createLocal();
        modification.setUserName(userName);
        modification.setAccountName(accountName);
        modification.setActionName(payload.getAction().getName());
        modification.setDate(new Date());
        modification.setArgument(new JsonBuilder().toJson((Object)payload));
        try {
            this.m_configModificationDao.insert(modification);
        }
        catch (Exception ex) {
            Cat.logError((Throwable)ex);
        }
    }

    private void storeModifyInfo(Context ctx, Payload payload) {
        Cookie cookie = ctx.getCookie("ct");
        if (cookie != null) {
            String cookieValue = cookie.getValue();
            try {
                String[] values = cookieValue.split("\\|");
                String userName = values[0];
                String account = values[1];
                if (userName.startsWith("\"")) {
                    userName = userName.substring(1, userName.length() - 1);
                }
                userName = URLDecoder.decode(userName, "UTF-8");
                this.store(userName, account, payload);
            }
            catch (Exception ex) {
                Cat.logError((String)("store cookie fail:" + cookieValue), (Throwable)new RuntimeException());
            }
        }
    }
}

