/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.rule.entity.MetricItem;
import com.dianping.cat.alarm.rule.entity.Rule;
import com.dianping.cat.alarm.rule.transform.DefaultJsonBuilder;
import com.dianping.cat.alarm.spi.decorator.RuleFTLDecorator;
import com.dianping.cat.report.alert.spi.config.BaseRuleConfigManager;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.processor.BaseProcesser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

public class BaseProcesser {
    @Inject
    protected RuleFTLDecorator m_ruleDecorator;

    public boolean addSubmitRule(BaseRuleConfigManager manager, String id, String metrics, String configs) {
        try {
            String xmlContent = manager.updateRule(id, metrics, configs);
            return manager.insert(xmlContent);
        }
        catch (Exception ex) {
            Cat.logError((Throwable)ex);
            return false;
        }
    }

    public boolean deleteRule(BaseRuleConfigManager manager, String key) {
        try {
            String xmlContent = manager.deleteRule(key);
            return manager.insert(xmlContent);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void generateRuleConfigContent(String key, BaseRuleConfigManager manager, Model model) {
        Rule rule;
        String configsStr = "";
        String ruleId = "";
        if (StringUtils.isNotEmpty((String)key) && (rule = manager.queryRule(key)) != null) {
            ruleId = rule.getId();
            configsStr = new DefaultJsonBuilder(true).buildArray((Collection)rule.getConfigs());
            String configHeader = new DefaultJsonBuilder(true).buildArray((Collection)rule.getMetricItems());
            model.setConfigHeader(configHeader);
        }
        String content = this.m_ruleDecorator.generateConfigsHtml(configsStr);
        model.setContent(content);
        model.setId(ruleId);
    }

    public void generateRuleItemList(BaseRuleConfigManager manager, Model model) {
        Collection rules = manager.getMonitorRules().getRules().values();
        ArrayList<RuleItem> ruleItems = new ArrayList<RuleItem>();
        for (Rule rule : rules) {
            String id = rule.getId();
            List items = rule.getMetricItems();
            if (items.size() <= 0) continue;
            MetricItem item = (MetricItem)items.get(0);
            String productText = item.getProductText();
            String metricText = item.getMetricItemText();
            RuleItem ruleItem = new RuleItem(this, id, productText, metricText);
            ruleItem.setMonitorCount(item.isMonitorCount());
            ruleItem.setMonitorAvg(item.isMonitorAvg());
            ruleItem.setMonitorSum(item.isMonitorSum());
            ruleItems.add(ruleItem);
        }
        model.setRuleItems(ruleItems);
    }
}

