/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.home.dependency.config.entity.DomainConfig;
import com.dianping.cat.home.dependency.config.entity.EdgeConfig;
import com.dianping.cat.report.page.dependency.config.TopoGraphFormatConfigManager;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphConfigManager;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.ConfigHtmlParser;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.DependencyConfigProcessor;
import com.dianping.cat.system.page.config.processor.GlobalConfigProcessor;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

public class DependencyConfigProcessor {
    @Inject
    private GlobalConfigProcessor m_globalConfigManager;
    @Inject
    private TopologyGraphConfigManager m_topologyConfigManager;
    @Inject
    private TopoGraphFormatConfigManager m_formatConfigManager;
    @Inject
    private ConfigHtmlParser m_configHtmlParser;

    private void graphEdgeConfigAdd(Payload payload, Model model) {
        String type = payload.getType();
        String from = payload.getFrom();
        String to = payload.getTo();
        EdgeConfig config = this.m_topologyConfigManager.queryEdgeConfig(type, from, to);
        model.setEdgeConfig(config);
    }

    private boolean graphEdgeConfigAddOrUpdateSubmit(Payload payload, Model model) {
        EdgeConfig config = payload.getEdgeConfig();
        if (!StringUtils.isEmpty((String)config.getType())) {
            model.setEdgeConfig(config);
            payload.setType(config.getType());
            return this.m_topologyConfigManager.insertEdgeConfig(config);
        }
        return false;
    }

    private boolean graphEdgeConfigDelete(Payload payload) {
        return this.m_topologyConfigManager.deleteEdgeConfig(payload.getType(), payload.getFrom(), payload.getTo());
    }

    private void graphNodeConfigAddOrUpdate(Payload payload, Model model) {
        String domain = payload.getDomain();
        String type = payload.getType();
        if (!StringUtils.isEmpty((String)domain)) {
            model.setDomainConfig(this.m_topologyConfigManager.queryNodeConfig(type, domain));
        }
    }

    private boolean graphNodeConfigAddOrUpdateSubmit(Payload payload, Model model) {
        String type = payload.getType();
        DomainConfig config = payload.getDomainConfig();
        String domain = config.getId();
        model.setDomainConfig(config);
        if ("All".equalsIgnoreCase(domain)) {
            return this.m_topologyConfigManager.insertDomainDefaultConfig(type, config);
        }
        return this.m_topologyConfigManager.insertDomainConfig(type, config);
    }

    private boolean graphNodeConfigDelete(Payload payload) {
        return this.m_topologyConfigManager.deleteDomainConfig(payload.getType(), payload.getDomain());
    }

    public void process(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                model.setGraphConfig(this.m_topologyConfigManager.getConfig());
                break;
            }
            case 2: {
                this.graphNodeConfigAddOrUpdate(payload, model);
                model.setProjects(this.m_globalConfigManager.queryAllProjects());
                break;
            }
            case 3: {
                model.setOpState(this.graphNodeConfigAddOrUpdateSubmit(payload, model));
                model.setGraphConfig(this.m_topologyConfigManager.getConfig());
                break;
            }
            case 4: {
                model.setOpState(this.graphNodeConfigDelete(payload));
                model.setConfig(this.m_topologyConfigManager.getConfig());
                break;
            }
            case 5: {
                model.setGraphConfig(this.m_topologyConfigManager.getConfig());
                model.buildEdgeInfo();
                break;
            }
            case 6: {
                this.graphEdgeConfigAdd(payload, model);
                model.setProjects(this.m_globalConfigManager.queryAllProjects());
                break;
            }
            case 7: {
                model.setOpState(this.graphEdgeConfigAddOrUpdateSubmit(payload, model));
                model.setGraphConfig(this.m_topologyConfigManager.getConfig());
                model.buildEdgeInfo();
                break;
            }
            case 8: {
                model.setGraphConfig(this.m_topologyConfigManager.getConfig());
                model.setOpState(this.graphEdgeConfigDelete(payload));
                model.buildEdgeInfo();
                break;
            }
            case 9: {
                String topoGraphFormat = payload.getContent();
                if (!StringUtils.isEmpty((String)topoGraphFormat)) {
                    model.setOpState(this.m_formatConfigManager.insert(topoGraphFormat));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_formatConfigManager.getConfig().toString()));
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
    }
}

