/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.login.service;

import com.dianping.cat.system.page.login.service.CookieManager;
import com.dianping.cat.system.page.login.service.SigninContext;
import com.dianping.cat.system.page.login.service.Token;
import com.dianping.cat.system.page.login.service.TokenBuilder;
import com.dianping.cat.system.page.login.spi.ITokenManager;
import org.unidal.lookup.annotation.Inject;

public class TokenManager
implements ITokenManager<SigninContext, Token> {
    @Inject
    private CookieManager m_cookieManager;
    @Inject
    private TokenBuilder m_tokenBuilder;

    public Token getToken(SigninContext ctx, String name) {
        String value = this.m_cookieManager.getCookie(ctx, name);
        if (value != null) {
            return this.m_tokenBuilder.parse(ctx, value);
        }
        return null;
    }

    public void removeToken(SigninContext ctx, String name) {
        this.m_cookieManager.removeCookie(ctx, name);
    }

    public void setToken(SigninContext ctx, Token token) {
        String name = token.getName();
        String value = this.m_tokenBuilder.build(ctx, token);
        this.m_cookieManager.setCookie(ctx, name, value);
    }
}

