/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.permission;

import com.dianping.cat.system.page.login.service.SigninContext;
import com.dianping.cat.system.page.login.service.Token;
import com.dianping.cat.system.page.login.service.TokenManager;
import com.dianping.cat.system.page.permission.ResourceConfigManager;
import com.dianping.cat.system.page.permission.UserConfigManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.PlexusContainer;
import org.unidal.initialization.DefaultModuleContext;
import org.unidal.lookup.ContainerLoader;

public class PermissionFilter
implements Filter {
    private static final String LOG_IN_URL = "/cat/s/login";
    private static final String LOGIN = "login";
    private static final String OP = "op";
    private static final String DEFAULT_OP = "view";
    private UserConfigManager m_userConfigManager;
    private ResourceConfigManager m_resourceConfigManager;
    private TokenManager m_tokenManager;
    private String m_errorPage;
    private String m_loginPage;

    public void init(FilterConfig filterConfig) throws ServletException {
        PlexusContainer container = ContainerLoader.getDefaultContainer();
        DefaultModuleContext ctx = new DefaultModuleContext(container);
        this.m_userConfigManager = (UserConfigManager)ctx.lookup(UserConfigManager.class);
        this.m_resourceConfigManager = (ResourceConfigManager)ctx.lookup(ResourceConfigManager.class);
        this.m_tokenManager = (TokenManager)ctx.lookup(TokenManager.class);
        this.m_errorPage = filterConfig.getInitParameter("errorPage");
        this.m_loginPage = filterConfig.getInitParameter(LOGIN);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpRequest.setCharacterEncoding("utf-8");
        SigninContext ctx = new SigninContext(httpRequest, httpResponse);
        String requestURI = httpRequest.getRequestURI();
        if (LOG_IN_URL.equals(requestURI)) {
            chain.doFilter(request, response);
        } else {
            int resourceRole;
            String op = httpRequest.getParameter(OP);
            if (op == null) {
                op = DEFAULT_OP;
            }
            if ((resourceRole = this.m_resourceConfigManager.getRole(requestURI, op)) == 1) {
                chain.doFilter(request, response);
            } else {
                Token token = this.m_tokenManager.getToken(ctx, "ct");
                if (token == null) {
                    request.getRequestDispatcher(this.m_loginPage).forward(request, response);
                } else {
                    int userRole = this.m_userConfigManager.getRole(token.getUserName());
                    if (userRole >= resourceRole) {
                        chain.doFilter(request, response);
                    } else {
                        request.getRequestDispatcher(this.m_errorPage).forward(request, response);
                    }
                }
            }
        }
    }

    public void destroy() {
    }
}

