/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.project;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.service.ProjectService;
import com.dianping.cat.system.SystemPage;
import com.dianping.cat.system.page.project.Action;
import com.dianping.cat.system.page.project.Context;
import com.dianping.cat.system.page.project.Handler;
import com.dianping.cat.system.page.project.JspViewer;
import com.dianping.cat.system.page.project.Model;
import com.dianping.cat.system.page.project.Payload;
import com.dianping.cat.system.page.project.UpdateStatus;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    public ProjectService m_projectService;
    @Inject
    private JspViewer m_jspViewer;

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="project")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="project")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        switch (1.$SwitchMap$com$dianping$cat$system$page$project$Action[action.ordinal()]) {
            case 1: {
                JsonBuilder jb = new JsonBuilder();
                Set domains = this.m_projectService.findAllDomains();
                HashMap<String, Set> jsons = new HashMap<String, Set>();
                jsons.put("domains", domains);
                model.setContent(jb.toJson(jsons));
                break;
            }
            case 2: {
                try {
                    Project temp;
                    Project project = payload.getProject();
                    if (project.getDomain() == null) {
                        project.setDomain("cat");
                    }
                    if ((temp = this.m_projectService.findByDomain(project.getDomain())) == null) {
                        this.m_projectService.insert(project);
                    } else {
                        this.m_projectService.update(project);
                    }
                    model.setContent(UpdateStatus.SUCCESS.getStatusJson());
                    break;
                }
                catch (Exception e) {
                    model.setContent(UpdateStatus.INTERNAL_ERROR.getStatusJson());
                    Cat.logError((Throwable)e);
                }
            }
        }
        model.setAction((org.unidal.web.mvc.Action)action);
        model.setPage((Page)SystemPage.PROJECT);
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }
}

