/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.entity.ProcessDomain;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.state.StateBuilder;
import com.dianping.cat.report.page.state.service.StateReportService;
import com.dianping.cat.system.page.router.config.AdjustStateReportVisitor;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import com.dianping.cat.system.page.router.service.RouterConfigService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalException;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class RouterConfigAdjustor {
    @Inject
    private StateReportService m_stateReportService;
    @Inject
    private RouterConfigManager m_configManager;
    @Inject
    private RouterConfigService m_routerService;
    @Inject
    private ServerConfigManager m_serverConfigManager;
    @Inject
    private DailyReportDao m_dailyReportDao;

    public void Adjust(Date period) {
        Date end = new Date(period.getTime() + 3600000L);
        RouterConfig routerConfig = this.m_routerService.queryLastReport("cat");
        StateReport report = this.m_stateReportService.queryHourlyReport("cat", period, end);
        String remoteServers = this.m_serverConfigManager.getConsoleRemoteServers();
        List servers = Splitters.by((String)",").noEmptyItem().split(remoteServers);
        AdjustStateReportVisitor visitor = new AdjustStateReportVisitor(this.m_configManager, servers);
        visitor.visitStateReport(report);
        Map statistics = visitor.getStatistics();
        Map gaps = this.buildGroupServersGaps(statistics);
        Map results = this.buildAdjustServers(gaps, routerConfig, statistics);
        this.updateRouterConfig(routerConfig, results);
        this.updateRouterConfigToDB(routerConfig);
    }

    private Map<String, Map<String, Server>> buildAdjustServers(Map<String, Map<Server, Long>> gaps, RouterConfig routerConfig, Map<String, Map<String, Machine>> statistics) {
        HashMap<String, Map<String, Server>> results = new HashMap<String, Map<String, Server>>();
        Map groupDomain2Gaps = this.buildGroupNeedAdjustDomains(gaps, statistics);
        for (Map.Entry<String, Map<Server, Long>> entry : gaps.entrySet()) {
            String group = entry.getKey();
            Map ds = (Map)groupDomain2Gaps.get(group);
            Map map = this.fillWithAdjustDomains(entry.getValue(), ds);
            results.put(group, map);
        }
        return results;
    }

    private Map<String, Map<String, Long>> buildGroupNeedAdjustDomains(Map<String, Map<Server, Long>> gaps, Map<String, Map<String, Machine>> statistics) {
        String group;
        HashMap<String, Map<String, Long>> results = new HashMap<String, Map<String, Long>>();
        HashMap<String, Map> datas = new HashMap<String, Map>();
        for (Map.Entry<String, Map<Server, Long>> entry : gaps.entrySet()) {
            group = entry.getKey();
            Map domains = this.buildNeedAdjustDomains(group, statistics.get(group), entry.getValue());
            datas.put(group, domains);
        }
        for (Map.Entry<String, Map<Object, Long>> entry : datas.entrySet()) {
            group = entry.getKey();
            Map ds = SortHelper.sortMap(entry.getValue(), (Comparator)new /* Unavailable Anonymous Inner Class!! */);
            results.put(group, ds);
        }
        return results;
    }

    private Map<String, Map<Server, Long>> buildGroupServersGaps(Map<String, Map<String, Machine>> statistics) {
        HashMap<String, Map<Server, Long>> results = new HashMap<String, Map<Server, Long>>();
        for (Map.Entry<String, Map<String, Machine>> entry : statistics.entrySet()) {
            String group = entry.getKey();
            Map gaps = this.processGroupMachines(entry.getValue());
            results.put(group, gaps);
        }
        return results;
    }

    private Map<String, Long> buildNeedAdjustDomains(String group, Map<String, Machine> statistics, Map<Server, Long> gaps) {
        HashMap<String, Long> datas = new HashMap<String, Long>();
        for (Map.Entry<Server, Long> g : gaps.entrySet()) {
            long gap = g.getValue();
            if (gap <= 0L) continue;
            String ip = g.getKey().getId();
            Map processDomains = statistics.get(ip).getProcessDomains();
            long sum = 0L;
            for (Map.Entry e : processDomains.entrySet()) {
                long count = ((ProcessDomain)e.getValue()).getTotal();
                String domain = ((ProcessDomain)e.getValue()).getName();
                boolean noExist = this.m_configManager.notCustomizedDomains(group, domain);
                if (!noExist || sum >= gap || count > gap - sum) continue;
                datas.put(domain, count);
                sum += count;
            }
        }
        return datas;
    }

    private long calculateTotal(Map<String, Machine> machines) {
        long total = 0L;
        for (Map.Entry<String, Machine> e : machines.entrySet()) {
            total += e.getValue().getTotal();
        }
        return total;
    }

    private Map<String, Server> fillWithAdjustDomains(Map<Server, Long> servers, Map<String, Long> ds) {
        HashMap<String, Server> results = new HashMap<String, Server>();
        for (Map.Entry<Server, Long> g : servers.entrySet()) {
            long gap = g.getValue();
            if (gap >= 0L) continue;
            List domains = this.findNearGapData(-gap, ds);
            for (String domain : domains) {
                results.put(domain, g.getKey());
            }
        }
        return results;
    }

    private List<String> findNearGapData(long gap, Map<String, Long> datas) {
        ArrayList<String> rets = new ArrayList<String>();
        long sum = 0L;
        for (Map.Entry<String, Long> entry : datas.entrySet()) {
            long count = entry.getValue();
            if (sum >= gap || count > gap - sum) continue;
            rets.add(entry.getKey());
            sum += count;
        }
        for (String domain : rets) {
            datas.remove(domain);
        }
        return rets;
    }

    private Map<Server, Long> processGroupMachines(Map<String, Machine> machines) {
        HashMap<Server, Long> results = new HashMap<Server, Long>();
        long total = this.calculateTotal(machines);
        Long minGap = total / 100L;
        long avg = total / (long)machines.size();
        for (Machine machine : machines.values()) {
            long count = machine.getTotal();
            DefaultServer server = this.m_configManager.queryServerByIp(machine.getIp());
            double weight = server.getWeight();
            long gap = (long)((double)count / weight - (double)avg);
            boolean loss = StateBuilder.checkTooMuchLoss((Machine)machine);
            if (Math.abs(gap) <= minGap && !loss) continue;
            gap = loss ? machine.getTotalLoss() * 2L : (long)(gap < 0L ? (double)gap * weight : (double)gap / weight);
            Server s = new Server();
            s.setId(server.getId()).setPort(server.getPort()).setWeight(weight);
            results.put(s, gap);
        }
        return results;
    }

    private void updateRouterConfig(RouterConfig routerConfig, Map<String, Map<String, Server>> results) {
        for (Map.Entry<String, Map<String, Server>> entry : results.entrySet()) {
            String group = entry.getKey();
            Map<String, Server> value = entry.getValue();
            for (Map.Entry<String, Server> e : value.entrySet()) {
                Group g;
                Domain d = routerConfig.findDomain(e.getKey());
                if (d == null || (g = d.findGroup(group)) == null) continue;
                List servers = g.getServers();
                servers.set(0, e.getValue());
            }
        }
    }

    public boolean updateRouterConfigToDB(RouterConfig config) {
        try {
            String name = "router";
            String domain = "cat";
            List reports = this.m_dailyReportDao.queryLatestReportsByDomainName(domain, name, 1, DailyReportEntity.READSET_FULL);
            DailyReport oldReport = (DailyReport)reports.get(0);
            DailyReport dailyReport = new DailyReport();
            dailyReport.setCreationDate(new Date());
            dailyReport.setDomain(domain);
            dailyReport.setIp(oldReport.getIp());
            dailyReport.setName(name);
            dailyReport.setPeriod(oldReport.getPeriod());
            dailyReport.setType(oldReport.getType());
            this.m_dailyReportDao.deleteByPK(oldReport);
            byte[] binaryContent = DefaultNativeBuilder.build((RouterConfig)config);
            this.m_routerService.insertDailyReport(dailyReport, binaryContent);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }
}

