/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;
import com.dianping.cat.home.router.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.state.service.StateReportService;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import com.dianping.cat.system.page.router.config.StateReportVisitor;
import com.dianping.cat.system.page.router.service.RouterConfigService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class RouterConfigHandler
implements LogEnabled {
    protected Logger m_logger;
    @Inject
    private StateReportService m_stateReportService;
    @Inject
    private RouterConfigManager m_configManager;
    @Inject
    private RouterConfigService m_reportService;
    @Inject
    private DailyReportDao m_dailyReportDao;

    private void addServerList(List<Server> servers, Server server) {
        for (Server s : servers) {
            if (!s.getId().equals(server.getId())) continue;
            return;
        }
        servers.add(server);
    }

    public RouterConfig buildRouterConfig(String domain, Date period) {
        Map numbers;
        String group;
        Date end = new Date(period.getTime() + 86400000L);
        StateReport report = (StateReport)this.m_stateReportService.queryReport("cat", period, end);
        RouterConfig routerConfig = new RouterConfig("cat");
        StateReportVisitor visitor = new StateReportVisitor(this.m_configManager);
        visitor.visitStateReport(report);
        Map statistics = visitor.getStatistics();
        Map servers = this.findAvaliableGpToSvrs();
        for (Map.Entry entry : servers.entrySet()) {
            group = (String)entry.getKey();
            numbers = (Map)statistics.get(group);
            if (numbers == null) continue;
            this.processMainServer((Map)entry.getValue(), routerConfig, numbers, group);
        }
        for (Map.Entry entry : servers.entrySet()) {
            group = (String)entry.getKey();
            numbers = (Map)statistics.get(group);
            if (numbers == null) continue;
            this.processBackServer((Map)entry.getValue(), routerConfig, numbers, group);
        }
        for (Map.Entry entry : servers.entrySet()) {
            for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                Cat.logEvent((String)"RouterConfig", (String)((String)entry.getKey() + ":" + ((Server)e.getKey()).getId() + ":" + e.getValue()), (String)"0", null);
            }
        }
        routerConfig.setStartTime(period);
        routerConfig.setEndTime(end);
        return routerConfig;
    }

    private boolean checkDomainConfig(String group, Domain defaultDomainConfig) {
        return defaultDomainConfig == null || defaultDomainConfig.findGroup(group) == null || defaultDomainConfig.findGroup(group).getServers().isEmpty();
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Map<String, Map<Server, Long>> findAvaliableGpToSvrs() {
        HashMap<String, Map<Server, Long>> results = new HashMap<String, Map<Server, Long>>();
        Map servers = this.m_configManager.queryEnableServers();
        RouterConfig routerConfig = this.m_configManager.getRouterConfig();
        Map groups = routerConfig.getServerGroups();
        for (Map.Entry entry : routerConfig.getNetworkPolicies().entrySet()) {
            NetworkPolicy networkPolicy = (NetworkPolicy)entry.getValue();
            ServerGroup serverGroup = (ServerGroup)groups.get(networkPolicy.getServerGroup());
            if (networkPolicy.isBlock() || serverGroup == null) continue;
            HashMap<Server, Long> networkResults = new HashMap<Server, Long>();
            for (GroupServer s : serverGroup.getGroupServers().values()) {
                Server server = (Server)servers.get(s.getId());
                if (server == null) continue;
                networkResults.put(server, 0L);
            }
            results.put((String)entry.getKey(), (Map<Server, Long>)networkResults);
        }
        return results;
    }

    private Server findMinServer(Map<Server, Long> servers) {
        long min = Long.MAX_VALUE;
        Server result = null;
        for (Map.Entry<Server, Long> entry : servers.entrySet()) {
            Server server = entry.getKey();
            Long value = (long)((double)entry.getValue().longValue() / server.getWeight());
            if (value >= min) continue;
            result = entry.getKey();
            min = value;
        }
        return result;
    }

    private Map<Server, Long> findOrCreateBacks(Map<Server, Long> servers, Map<Server, Map<Server, Long>> backServers, Server server) {
        Map<Server, Long> serverProcess = backServers.get(server);
        if (serverProcess == null) {
            serverProcess = new LinkedHashMap<Server, Long>();
            for (Map.Entry<Server, Long> entry : servers.entrySet()) {
                if (entry.getKey().equals((Object)server)) continue;
                serverProcess.put(entry.getKey(), entry.getValue());
            }
            backServers.put(server, serverProcess);
        }
        return serverProcess;
    }

    private void processBackServer(Map<Server, Long> servers, RouterConfig routerConfig, Map<String, Long> statistics, String group) {
        LinkedHashMap backServers = new LinkedHashMap();
        Server backUpServer = this.m_configManager.queryBackUpServer();
        Collection values = routerConfig.getDomains().values();
        for (Domain domain : values) {
            try {
                Group serverGroup = domain.findGroup(group);
                if (serverGroup == null || serverGroup.getServers().isEmpty()) continue;
                List domainServers = serverGroup.getServers();
                Domain defaultDomainConfig = this.m_configManager.getRouterConfig().findDomain(domain.getId());
                if (!this.checkDomainConfig(group, defaultDomainConfig)) continue;
                Server mainServer = (Server)serverGroup.getServers().get(0);
                Map backs = this.findOrCreateBacks(servers, backServers, mainServer);
                Server secondServer = this.findMinServer(backs);
                if (secondServer != null) {
                    Long oldValue = (Long)backs.get(secondServer);
                    backs.put(secondServer, oldValue + statistics.get(domain.getId()));
                    this.addServerList(domainServers, secondServer);
                }
                this.addServerList(domainServers, backUpServer);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    private void processMainServer(Map<Server, Long> servers, RouterConfig routerConfig, Map<String, Long> statistics, String group) {
        for (Map.Entry<String, Long> entry : statistics.entrySet()) {
            try {
                Long oldValue;
                Domain domainConfig;
                String domainName = entry.getKey();
                Domain defaultDomainConfig = this.m_configManager.getRouterConfig().findDomain(domainName);
                Long value = entry.getValue();
                if (this.checkDomainConfig(group, defaultDomainConfig)) {
                    domainConfig = routerConfig.findOrCreateDomain(domainName);
                    Server server = this.findMinServer(servers);
                    if (server == null) continue;
                    Group serverGroup = domainConfig.findOrCreateGroup(group);
                    oldValue = servers.get(server);
                    serverGroup.addServer(server);
                    servers.put(server, oldValue + value);
                    continue;
                }
                domainConfig = routerConfig.findOrCreateDomain(domainName);
                Group serverGroup = defaultDomainConfig.findGroup(group);
                domainConfig.addGroup(serverGroup);
                Server server = (Server)serverGroup.getServers().get(0);
                oldValue = servers.get(server);
                if (oldValue == null) continue;
                servers.put(server, oldValue + value);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    public boolean updateRouterConfig(Date period) {
        try {
            String name = "router";
            String domain = "cat";
            RouterConfig routerConfig = this.buildRouterConfig(domain, period);
            DailyReport dailyReport = new DailyReport();
            dailyReport.setCreationDate(new Date());
            dailyReport.setDomain(domain);
            dailyReport.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            dailyReport.setName(name);
            dailyReport.setPeriod(period);
            dailyReport.setType(1);
            this.m_dailyReportDao.deleteByDomainNamePeriod(dailyReport);
            byte[] binaryContent = DefaultNativeBuilder.build((RouterConfig)routerConfig);
            this.m_reportService.insertDailyReport(dailyReport, binaryContent);
            return true;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }
}

