/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentDao;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.Network;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;
import com.dianping.cat.home.router.transform.DefaultNativeParser;
import com.dianping.cat.home.router.transform.DefaultSaxParser;
import com.dianping.cat.task.TimerSyncTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.net.util.SubnetUtils;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Pair;
import org.xml.sax.SAXException;

@Named
public class RouterConfigManager
implements Initializable,
LogEnabled {
    public static final String DEFAULT = "default";
    private static final String CONFIG_NAME = "routerConfig";
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    @Inject
    private DailyReportDao m_dailyReportDao;
    @Inject
    private DailyReportContentDao m_dailyReportContentDao;
    private int m_configId;
    private volatile RouterConfig m_routerConfig;
    private Logger m_logger;
    private long m_modifyTime;
    private Map<String, List<SubnetUtils.SubnetInfo>> m_subNetInfos = new HashMap();
    private Map<String, String> m_ipToGroupInfo = new HashMap();
    private Map<Long, Pair<RouterConfig, Long>> m_routerConfigs = new /* Unavailable Anonymous Inner Class!! */;

    private void addServerList(List<Server> servers, Server server) {
        for (Server s : servers) {
            if (!s.getId().equals(server.getId())) continue;
            return;
        }
        servers.add(server);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public RouterConfig getRouterConfig() {
        return this.m_routerConfig;
    }

    public Map<Long, Pair<RouterConfig, Long>> getRouterConfigs() {
        return this.m_routerConfigs;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_routerConfig = DefaultSaxParser.parse((String)content);
            this.m_modifyTime = config.getModifyDate().getTime();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                Date now = new Date();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                config.setModifyDate(now);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_routerConfig = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = now.getTime();
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_routerConfig == null) {
            this.m_routerConfig = new RouterConfig();
        }
        this.refreshNetInfo();
        TimerSyncTask.getInstance().register((TimerSyncTask.SyncHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean insert(String xml) {
        try {
            RouterConfig routerConfig = DefaultSaxParser.parse((String)xml);
            if (this.validate(routerConfig)) {
                this.m_routerConfig = routerConfig;
                boolean result = this.storeConfig();
                if (result) {
                    this.refreshNetInfo();
                }
                return result;
            }
            return false;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            this.m_logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean notCustomizedDomains(String group, Domain domainConfig) {
        return domainConfig == null || domainConfig.findGroup(group) == null || domainConfig.findGroup(group).getServers().isEmpty();
    }

    public boolean notCustomizedDomains(String group, String domain) {
        Domain domainConfig = this.m_routerConfig.findDomain(domain);
        return this.notCustomizedDomains(group, domainConfig);
    }

    public Server queryBackUpServer() {
        return new Server().setId(this.m_routerConfig.getBackupServer()).setPort(this.m_routerConfig.getBackupServerPort());
    }

    public Map<String, Server> queryEnableServers() {
        return this.queryEnableServers(this.m_routerConfig);
    }

    private Map<String, Server> queryEnableServers(RouterConfig routerConfig) {
        Map servers = routerConfig.getDefaultServers();
        HashMap<String, Server> results = new HashMap<String, Server>();
        for (Map.Entry entry : servers.entrySet()) {
            DefaultServer server = (DefaultServer)entry.getValue();
            if (!server.isEnable()) continue;
            Server s = new Server().setId(server.getId()).setPort(server.getPort()).setWeight(server.getWeight());
            results.put((String)entry.getKey(), s);
        }
        return results;
    }

    private String queryGroupBySubnet(String ip) {
        for (Map.Entry entry : this.m_subNetInfos.entrySet()) {
            List subnetInfos = (List)entry.getValue();
            String group = (String)entry.getKey();
            for (SubnetUtils.SubnetInfo info : subnetInfos) {
                try {
                    if (!info.isInRange(ip)) continue;
                    return group;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public DefaultServer queryServerByIp(String ip) {
        DefaultServer server = (DefaultServer)this.m_routerConfig.getDefaultServers().get(ip);
        if (server != null) {
            return server;
        }
        return null;
    }

    public String queryServerGroupByIp(String ip) {
        String group = (String)this.m_ipToGroupInfo.get(ip);
        if (group == null) {
            group = this.queryGroupBySubnet(ip);
            if (group == null) {
                group = DEFAULT;
            }
            this.m_ipToGroupInfo.put(ip, group);
        }
        return group;
    }

    public List<Server> queryServersByDomain(String group, String domain) {
        Domain domainConfig = this.m_routerConfig.findDomain(domain);
        ArrayList<Server> result = new ArrayList<Server>();
        boolean noExist = this.notCustomizedDomains(group, domainConfig);
        if (noExist) {
            ArrayList<Object> servers = new ArrayList();
            Map enables = this.queryEnableServers();
            ServerGroup serverGroup = (ServerGroup)this.m_routerConfig.getServerGroups().get(group);
            if (serverGroup != null) {
                for (GroupServer s : serverGroup.getGroupServers().values()) {
                    servers.add(enables.get(s.getId()));
                }
            }
            if (servers.isEmpty()) {
                servers = new ArrayList(enables.values());
            }
            int length = servers.size();
            int hashCode = domain.hashCode();
            for (int i = 0; i < 2; ++i) {
                int index = Math.abs(hashCode + i) % length;
                this.addServerList(result, (Server)servers.get(index));
            }
            this.addServerList(result, this.queryBackUpServer());
        } else {
            result.addAll(domainConfig.findGroup(group).getServers());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfigInfo() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        RouterConfigManager routerConfigManager = this;
        synchronized (routerConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                RouterConfig routerConfig;
                String content = config.getContent();
                this.m_routerConfig = routerConfig = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = modifyTime;
                this.refreshNetInfo();
            }
        }
    }

    private void refreshNetInfo() {
        HashMap subNetInfos = new HashMap();
        for (Map.Entry netPolicy : this.m_routerConfig.getNetworkPolicies().entrySet()) {
            ArrayList<SubnetUtils.SubnetInfo> infos = new ArrayList<SubnetUtils.SubnetInfo>();
            if (DEFAULT.equals(netPolicy.getKey())) continue;
            for (Map.Entry network : ((NetworkPolicy)netPolicy.getValue()).getNetworks().entrySet()) {
                try {
                    SubnetUtils subnetUtils = new SubnetUtils(((Network)network.getValue()).getId());
                    SubnetUtils.SubnetInfo netInfo = subnetUtils.getInfo();
                    infos.add(netInfo);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
            subNetInfos.put(netPolicy.getKey(), infos);
        }
        this.m_subNetInfos = subNetInfos;
        this.m_ipToGroupInfo = new HashMap();
    }

    private void refreshReportInfo() throws Exception {
        Date period = TimeHelper.getCurrentDay((int)-1);
        long time = period.getTime();
        try {
            DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod("cat", "router", period, DailyReportEntity.READSET_FULL);
            long modifyTime = report.getCreationDate().getTime();
            Pair pair = (Pair)this.m_routerConfigs.get(time);
            if (pair == null || modifyTime > (Long)pair.getValue()) {
                try {
                    DailyReportContent reportContent = this.m_dailyReportContentDao.findByPK(report.getId(), DailyReportContentEntity.READSET_FULL);
                    RouterConfig routerConfig = DefaultNativeParser.parse((byte[])reportContent.getContent());
                    this.m_routerConfigs.put(time, new Pair((Object)routerConfig, (Object)modifyTime));
                    Cat.logEvent((String)"ReloadConfig", (String)"router");
                }
                catch (DalNotFoundException dalNotFoundException) {}
            }
        }
        catch (DalNotFoundException dalNotFoundException) {
            // empty catch block
        }
    }

    public boolean shouldBlock(String ip) {
        String group = this.queryServerGroupByIp(ip);
        NetworkPolicy networkPolicy = this.m_routerConfig.findNetworkPolicy(group);
        if (networkPolicy != null) {
            return networkPolicy.isBlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        RouterConfigManager routerConfigManager = this;
        synchronized (routerConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_routerConfig.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean validate(RouterConfig routerConfig) {
        Set servers = routerConfig.getDefaultServers().keySet();
        for (ServerGroup serverGroup : routerConfig.getServerGroups().values()) {
            for (GroupServer server : serverGroup.getGroupServers().values()) {
                if (servers.contains(server.getId())) continue;
                Cat.logError((Throwable)new RuntimeException("Error router config in group server, has no server ip: " + server));
                return false;
            }
        }
        if (this.queryEnableServers(routerConfig).isEmpty()) {
            Cat.logError((Throwable)new RuntimeException("Error router config, enable servers not exist."));
            return false;
        }
        return true;
    }

    static /* synthetic */ void access$000(RouterConfigManager x0) throws DalException, SAXException, IOException {
        x0.refreshConfigInfo();
    }

    static /* synthetic */ void access$100(RouterConfigManager x0) throws Exception {
        x0.refreshReportInfo();
    }
}

