/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.consumer.state.model.entity.ProcessDomain;
import com.dianping.cat.consumer.state.model.transform.BaseVisitor;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StateReportVisitor
extends BaseVisitor {
    private RouterConfigManager m_routerConfigManager;
    private Map<String, Map<String, Long>> m_statistics = new HashMap();
    private Comparator<Map.Entry<String, Long>> m_comparator = new /* Unavailable Anonymous Inner Class!! */;

    public StateReportVisitor(RouterConfigManager routerConfigManager) {
        this.m_routerConfigManager = routerConfigManager;
    }

    private void buildStatistics(ProcessDomain processDomain, Map<String, Double> weights) {
        long total = processDomain.getTotal();
        for (Map.Entry<String, Double> entry : weights.entrySet()) {
            String group = entry.getKey();
            HashMap<String, Long> datas = (HashMap<String, Long>)this.m_statistics.get(group);
            if (datas == null) {
                datas = new HashMap<String, Long>();
                this.m_statistics.put(group, datas);
            }
            String domain = processDomain.getName();
            Long value = (Long)datas.get(domain);
            long sumValue = (long)((double)total * entry.getValue());
            if (value == null) {
                datas.put(domain, sumValue);
                continue;
            }
            datas.put(domain, value + sumValue);
        }
    }

    private Map<String, Double> buildWeights(ProcessDomain processDomain) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        HashMap<String, Integer> weights = new HashMap<String, Integer>();
        int size = processDomain.getIps().size();
        for (String string : processDomain.getIps()) {
            String group = this.m_routerConfigManager.queryServerGroupByIp(string);
            Integer value = (Integer)weights.get(group);
            if (value == null) {
                weights.put(group, 1);
                continue;
            }
            weights.put(group, value + 1);
        }
        for (Map.Entry entry : weights.entrySet()) {
            results.put((String)entry.getKey(), (double)((Integer)entry.getValue()).intValue() / (double)size);
        }
        return results;
    }

    public Map<String, Map<String, Long>> getStatistics() {
        HashMap<String, Map<String, Long>> datas = new HashMap<String, Map<String, Long>>();
        for (Map.Entry entry : this.m_statistics.entrySet()) {
            Map ms = SortHelper.sortMap((Map)((Map)entry.getValue()), (Comparator)this.m_comparator);
            datas.put((String)entry.getKey(), ms);
        }
        return datas;
    }

    public void visitProcessDomain(ProcessDomain processDomain) {
        Map weights = this.buildWeights(processDomain);
        this.buildStatistics(processDomain, weights);
    }
}

