/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.config.transform;

import com.dianping.cat.home.dependency.config.entity.DomainConfig;
import com.dianping.cat.home.dependency.config.entity.EdgeConfig;
import com.dianping.cat.home.dependency.config.entity.NodeConfig;
import com.dianping.cat.home.dependency.config.entity.TopologyGraphConfig;
import com.dianping.cat.home.dependency.config.transform.IMaker;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    public DomainConfig buildDomainConfig(Attributes attributes) {
        String id = attributes.getValue("id");
        String warningThreshold = attributes.getValue("warning-threshold");
        String errorThreshold = attributes.getValue("error-threshold");
        String warningResponseTime = attributes.getValue("warning-response-time");
        String errorResponseTime = attributes.getValue("error-response-time");
        String minCountThreshold = attributes.getValue("min-count-threshold");
        DomainConfig domainConfig = new DomainConfig(id);
        if (warningThreshold != null) {
            domainConfig.setWarningThreshold(((Integer)this.convert(Integer.class, warningThreshold, (Object)0)).intValue());
        }
        if (errorThreshold != null) {
            domainConfig.setErrorThreshold(((Integer)this.convert(Integer.class, errorThreshold, (Object)0)).intValue());
        }
        if (warningResponseTime != null) {
            domainConfig.setWarningResponseTime(((Double)this.convert(Double.class, warningResponseTime, (Object)0.0)).doubleValue());
        }
        if (errorResponseTime != null) {
            domainConfig.setErrorResponseTime(((Double)this.convert(Double.class, errorResponseTime, (Object)0.0)).doubleValue());
        }
        if (minCountThreshold != null) {
            domainConfig.setMinCountThreshold(((Integer)this.convert(Integer.class, minCountThreshold, (Object)0)).intValue());
        }
        return domainConfig;
    }

    public EdgeConfig buildEdgeConfig(Attributes attributes) {
        String key = attributes.getValue("key");
        String type = attributes.getValue("type");
        String from = attributes.getValue("from");
        String to = attributes.getValue("to");
        String warningThreshold = attributes.getValue("warning-threshold");
        String errorThreshold = attributes.getValue("error-threshold");
        String warningResponseTime = attributes.getValue("warning-response-time");
        String errorResponseTime = attributes.getValue("error-response-time");
        String minCountThreshold = attributes.getValue("min-count-threshold");
        EdgeConfig edgeConfig = new EdgeConfig(key);
        if (type != null) {
            edgeConfig.setType(type);
        }
        if (from != null) {
            edgeConfig.setFrom(from);
        }
        if (to != null) {
            edgeConfig.setTo(to);
        }
        if (warningThreshold != null) {
            edgeConfig.setWarningThreshold(((Integer)this.convert(Integer.class, warningThreshold, (Object)0)).intValue());
        }
        if (errorThreshold != null) {
            edgeConfig.setErrorThreshold(((Integer)this.convert(Integer.class, errorThreshold, (Object)0)).intValue());
        }
        if (warningResponseTime != null) {
            edgeConfig.setWarningResponseTime(((Double)this.convert(Double.class, warningResponseTime, (Object)0.0)).doubleValue());
        }
        if (errorResponseTime != null) {
            edgeConfig.setErrorResponseTime(((Double)this.convert(Double.class, errorResponseTime, (Object)0.0)).doubleValue());
        }
        if (minCountThreshold != null) {
            edgeConfig.setMinCountThreshold(((Integer)this.convert(Integer.class, minCountThreshold, (Object)0)).intValue());
        }
        return edgeConfig;
    }

    public NodeConfig buildNodeConfig(Attributes attributes) {
        String type = attributes.getValue("type");
        String defaultWarningThreshold = attributes.getValue("default-warning-threshold");
        String defaultErrorThreshold = attributes.getValue("default-error-threshold");
        String defaultWarningResponseTime = attributes.getValue("default-warning-response-time");
        String defaultErrorResponseTime = attributes.getValue("default-error-response-time");
        String defaultMinCountThreshold = attributes.getValue("default-min-count-threshold");
        NodeConfig nodeConfig = new NodeConfig(type);
        if (defaultWarningThreshold != null) {
            nodeConfig.setDefaultWarningThreshold((Integer)this.convert(Integer.class, defaultWarningThreshold, null));
        }
        if (defaultErrorThreshold != null) {
            nodeConfig.setDefaultErrorThreshold((Integer)this.convert(Integer.class, defaultErrorThreshold, null));
        }
        if (defaultWarningResponseTime != null) {
            nodeConfig.setDefaultWarningResponseTime((Double)this.convert(Double.class, defaultWarningResponseTime, null));
        }
        if (defaultErrorResponseTime != null) {
            nodeConfig.setDefaultErrorResponseTime((Double)this.convert(Double.class, defaultErrorResponseTime, null));
        }
        if (defaultMinCountThreshold != null) {
            nodeConfig.setDefaultMinCountThreshold(((Integer)this.convert(Integer.class, defaultMinCountThreshold, (Object)0)).intValue());
        }
        return nodeConfig;
    }

    public TopologyGraphConfig buildTopologyGraphConfig(Attributes attributes) {
        TopologyGraphConfig topologyGraphConfig = new TopologyGraphConfig();
        return topologyGraphConfig;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

