/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.graph.transform;

import com.dianping.cat.home.dependency.graph.IEntity;
import com.dianping.cat.home.dependency.graph.IVisitor;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class DefaultJsonBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultJsonBuilder() {
        this(false);
    }

    public DefaultJsonBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultJsonBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_visitor = this;
    }

    protected void arrayBegin(String name) {
        this.indent();
        this.m_sb.append('\"').append(name).append(this.m_compact ? "\":[" : "\": [\r\n");
        ++this.m_level;
    }

    protected void arrayEnd(String name) {
        --this.m_level;
        this.trimComma();
        this.indent();
        this.m_sb.append("],").append(this.m_compact ? "" : "\r\n");
    }

    protected void attributes(Map<String, String> dynamicAttributes, Object ... nameValues) {
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                if (attrValue instanceof Collection) {
                    Collection items = (Collection)attrValue;
                    if (!items.isEmpty()) {
                        this.indent();
                        this.m_sb.append('\"').append(attrName).append(this.m_compact ? "\":[" : "\": [");
                        for (Object item : items) {
                            this.m_sb.append(' ');
                            this.toString(this.m_sb, item);
                            this.m_sb.append(',');
                        }
                        this.m_sb.setLength(this.m_sb.length() - 1);
                        this.m_sb.append(this.m_compact ? "]," : " ],\r\n");
                    }
                } else if (attrValue.getClass().isArray()) {
                    int length = Array.getLength(attrValue);
                    if (length > 0) {
                        this.indent();
                        this.m_sb.append('\"').append(attrName).append(this.m_compact ? "\":[" : "\": [");
                        for (int j = 0; j < length; ++j) {
                            Object item;
                            item = Array.get(attrValue, j);
                            this.m_sb.append(' ');
                            this.toString(this.m_sb, item);
                            this.m_sb.append(',');
                        }
                        this.m_sb.setLength(this.m_sb.length() - 1);
                        this.m_sb.append(this.m_compact ? "]," : " ],\r\n");
                    }
                } else if (this.m_compact) {
                    this.m_sb.append('\"').append(attrName).append("\":");
                    this.toString(this.m_sb, attrValue);
                    this.m_sb.append(",");
                } else {
                    this.indent();
                    this.m_sb.append('\"').append(attrName).append("\": ");
                    this.toString(this.m_sb, attrValue);
                    this.m_sb.append(",\r\n");
                }
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                if (this.m_compact) {
                    this.m_sb.append('\"').append(e.getKey()).append("\":");
                    this.toString(this.m_sb, (Object)e.getValue());
                    this.m_sb.append(",");
                    continue;
                }
                this.indent();
                this.m_sb.append('\"').append(e.getKey()).append("\": ");
                this.toString(this.m_sb, (Object)e.getValue());
                this.m_sb.append(",\r\n");
            }
        }
    }

    public String build(IEntity<?> entity) {
        this.objectBegin(null);
        entity.accept((IVisitor)this);
        this.objectEnd(null);
        this.trimComma();
        return this.m_sb.toString();
    }

    public String buildArray(Collection<? extends IEntity<?>> entities) {
        this.m_sb.append('[');
        if (entities != null) {
            for (IEntity<?> entity : entities) {
                this.objectBegin(null);
                entity.accept((IVisitor)this);
                this.objectEnd(null);
            }
            this.trimComma();
        }
        this.m_sb.append(']');
        return this.m_sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void objectBegin(String name) {
        this.indent();
        if (name == null) {
            this.m_sb.append("{").append(this.m_compact ? "" : "\r\n");
        } else {
            this.m_sb.append('\"').append(name).append(this.m_compact ? "\":{" : "\": {\r\n");
        }
        ++this.m_level;
    }

    protected void objectEnd(String name) {
        --this.m_level;
        this.trimComma();
        this.indent();
        this.m_sb.append(this.m_compact ? "}," : "},\r\n");
    }

    protected void toString(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Boolean || value instanceof Number) {
            sb.append(value);
        } else {
            String val = value.toString();
            int len = val.length();
            sb.append('\"');
            block6: for (int i = 0; i < len; ++i) {
                char ch = val.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append('\\').append(ch);
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            sb.append('\"');
        }
    }

    protected void trimComma() {
        int len = this.m_sb.length();
        if (this.m_compact) {
            if (len > 1 && this.m_sb.charAt(len - 1) == ',') {
                this.m_sb.replace(len - 1, len, "");
            }
        } else if (len > 3 && this.m_sb.charAt(len - 3) == ',') {
            this.m_sb.replace(len - 3, len - 2, "");
        }
    }

    public void visitTopologyEdge(TopologyEdge topologyEdge) {
        this.attributes(null, new Object[]{"key", topologyEdge.getKey(), "type", topologyEdge.getType(), "target", topologyEdge.getTarget(), "opposite", topologyEdge.isOpposite(), "weight", topologyEdge.getWeight(), "status", topologyEdge.getStatus(), "des", topologyEdge.getDes(), "link", topologyEdge.getLink(), "self", topologyEdge.getSelf(), "dashed", topologyEdge.isDashed()});
    }

    public void visitTopologyGraph(TopologyGraph topologyGraph) {
        String key;
        this.attributes(null, new Object[]{"id", topologyGraph.getId(), "type", topologyGraph.getType(), "status", topologyGraph.getStatus(), "des", topologyGraph.getDes()});
        if (!topologyGraph.getNodes().isEmpty()) {
            this.objectBegin("nodes");
            for (Map.Entry e : topologyGraph.getNodes().entrySet()) {
                key = String.valueOf(e.getKey());
                this.objectBegin(key);
                ((TopologyNode)e.getValue()).accept(this.m_visitor);
                this.objectEnd(key);
            }
            this.objectEnd("nodes");
        }
        if (!topologyGraph.getEdges().isEmpty()) {
            this.objectBegin("edges");
            for (Map.Entry e : topologyGraph.getEdges().entrySet()) {
                key = String.valueOf(e.getKey());
                this.objectBegin(key);
                ((TopologyEdge)e.getValue()).accept(this.m_visitor);
                this.objectEnd(key);
            }
            this.objectEnd("edges");
        }
    }

    public void visitTopologyNode(TopologyNode topologyNode) {
        this.attributes(null, new Object[]{"id", topologyNode.getId(), "type", topologyNode.getType(), "status", topologyNode.getStatus(), "des", topologyNode.getDes(), "link", topologyNode.getLink(), "weight", topologyNode.getWeight()});
    }
}

