/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heavy.transform;

import com.dianping.cat.home.heavy.IVisitor;
import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;

public abstract class BaseVisitor
implements IVisitor {
    public void visitHeavyCache(HeavyCache heavyCache) {
        for (Url url : heavyCache.getUrls().values()) {
            this.visitUrl(url);
        }
        for (Service service : heavyCache.getServices().values()) {
            this.visitService(service);
        }
    }

    public void visitHeavyCall(HeavyCall heavyCall) {
        for (Url url : heavyCall.getUrls().values()) {
            this.visitUrl(url);
        }
        for (Service service : heavyCall.getServices().values()) {
            this.visitService(service);
        }
    }

    public void visitHeavyReport(HeavyReport heavyReport) {
        if (heavyReport.getHeavySql() != null) {
            this.visitHeavySql(heavyReport.getHeavySql());
        }
        if (heavyReport.getHeavyCall() != null) {
            this.visitHeavyCall(heavyReport.getHeavyCall());
        }
        if (heavyReport.getHeavyCache() != null) {
            this.visitHeavyCache(heavyReport.getHeavyCache());
        }
    }

    public void visitHeavySql(HeavySql heavySql) {
        for (Url url : heavySql.getUrls().values()) {
            this.visitUrl(url);
        }
        for (Service service : heavySql.getServices().values()) {
            this.visitService(service);
        }
    }

    public void visitService(Service service) {
    }

    public void visitUrl(Url url) {
    }
}

