/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heavy.transform;

import com.dianping.cat.home.heavy.IEntity;
import com.dianping.cat.home.heavy.IVisitor;
import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private HeavyReport m_heavyReport;

    public DefaultMerger() {
    }

    public DefaultMerger(HeavyReport heavyReport) {
        this.m_heavyReport = heavyReport;
        this.m_objs.push(heavyReport);
    }

    public HeavyReport getHeavyReport() {
        return this.m_heavyReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeHeavyCache(HeavyCache to, HeavyCache from) {
        to.mergeAttributes(from);
    }

    protected void mergeHeavyCall(HeavyCall to, HeavyCall from) {
        to.mergeAttributes(from);
    }

    protected void mergeHeavyReport(HeavyReport to, HeavyReport from) {
        to.mergeAttributes(from);
    }

    protected void mergeHeavySql(HeavySql to, HeavySql from) {
        to.mergeAttributes(from);
    }

    protected void mergeService(Service to, Service from) {
        to.mergeAttributes(from);
    }

    protected void mergeUrl(Url to, Url from) {
        to.mergeAttributes(from);
    }

    public void visitHeavyCache(HeavyCache from) {
        HeavyCache to = (HeavyCache)this.m_objs.peek();
        this.mergeHeavyCache(to, from);
        this.visitHeavyCacheChildren(to, from);
    }

    protected void visitHeavyCacheChildren(HeavyCache to, HeavyCache from) {
        Url target;
        for (Url source : from.getUrls().values()) {
            target = to.findUrl(source.getKey());
            if (target == null) {
                target = new Url(source.getKey());
                to.addUrl(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Url source : from.getServices().values()) {
            target = to.findService(source.getKey());
            if (target == null) {
                target = new Service(source.getKey());
                to.addService((Service)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitHeavyCall(HeavyCall from) {
        HeavyCall to = (HeavyCall)this.m_objs.peek();
        this.mergeHeavyCall(to, from);
        this.visitHeavyCallChildren(to, from);
    }

    protected void visitHeavyCallChildren(HeavyCall to, HeavyCall from) {
        Url target;
        for (Url source : from.getUrls().values()) {
            target = to.findUrl(source.getKey());
            if (target == null) {
                target = new Url(source.getKey());
                to.addUrl(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Url source : from.getServices().values()) {
            target = to.findService(source.getKey());
            if (target == null) {
                target = new Service(source.getKey());
                to.addService((Service)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitHeavyReport(HeavyReport from) {
        HeavyReport to = (HeavyReport)this.m_objs.peek();
        this.mergeHeavyReport(to, from);
        this.visitHeavyReportChildren(to, from);
    }

    protected void visitHeavyReportChildren(HeavyReport to, HeavyReport from) {
        HeavySql target;
        if (from.getHeavySql() != null) {
            target = to.getHeavySql();
            if (target == null) {
                target = new HeavySql();
                to.setHeavySql(target);
            }
            this.m_objs.push(target);
            from.getHeavySql().accept((IVisitor)this);
            this.m_objs.pop();
        }
        if (from.getHeavyCall() != null) {
            target = to.getHeavyCall();
            if (target == null) {
                target = new HeavyCall();
                to.setHeavyCall((HeavyCall)target);
            }
            this.m_objs.push(target);
            from.getHeavyCall().accept((IVisitor)this);
            this.m_objs.pop();
        }
        if (from.getHeavyCache() != null) {
            target = to.getHeavyCache();
            if (target == null) {
                target = new HeavyCache();
                to.setHeavyCache((HeavyCache)target);
            }
            this.m_objs.push(target);
            from.getHeavyCache().accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitHeavySql(HeavySql from) {
        HeavySql to = (HeavySql)this.m_objs.peek();
        this.mergeHeavySql(to, from);
        this.visitHeavySqlChildren(to, from);
    }

    protected void visitHeavySqlChildren(HeavySql to, HeavySql from) {
        Url target;
        for (Url source : from.getUrls().values()) {
            target = to.findUrl(source.getKey());
            if (target == null) {
                target = new Url(source.getKey());
                to.addUrl(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Url source : from.getServices().values()) {
            target = to.findService(source.getKey());
            if (target == null) {
                target = new Service(source.getKey());
                to.addService((Service)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitService(Service from) {
        Service to = (Service)this.m_objs.peek();
        this.mergeService(to, from);
        this.visitServiceChildren(to, from);
    }

    protected void visitServiceChildren(Service to, Service from) {
    }

    public void visitUrl(Url from) {
        Url to = (Url)this.m_objs.peek();
        this.mergeUrl(to, from);
        this.visitUrlChildren(to, from);
    }

    protected void visitUrlChildren(Url to, Url from) {
    }
}

