/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heavy.transform;

import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;
import com.dianping.cat.home.heavy.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    public HeavyCache buildHeavyCache(Attributes attributes) {
        HeavyCache heavyCache = new HeavyCache();
        return heavyCache;
    }

    public HeavyCall buildHeavyCall(Attributes attributes) {
        HeavyCall heavyCall = new HeavyCall();
        return heavyCall;
    }

    public HeavyReport buildHeavyReport(Attributes attributes) {
        String domain = attributes.getValue("domain");
        String startTime = attributes.getValue("startTime");
        String endTime = attributes.getValue("endTime");
        HeavyReport heavyReport = new HeavyReport(domain);
        if (startTime != null) {
            heavyReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            heavyReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return heavyReport;
    }

    public HeavySql buildHeavySql(Attributes attributes) {
        HeavySql heavySql = new HeavySql();
        return heavySql;
    }

    public Service buildService(Attributes attributes) {
        String domain = attributes.getValue("domain");
        String name = attributes.getValue("name");
        String logview = attributes.getValue("logview");
        String count = attributes.getValue("count");
        String key = attributes.getValue("key");
        Service service = new Service(key);
        if (domain != null) {
            service.setDomain(domain);
        }
        if (name != null) {
            service.setName(name);
        }
        if (logview != null) {
            service.setLogview(logview);
        }
        if (count != null) {
            service.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        return service;
    }

    public Url buildUrl(Attributes attributes) {
        String domain = attributes.getValue("domain");
        String name = attributes.getValue("name");
        String logview = attributes.getValue("logview");
        String count = attributes.getValue("count");
        String key = attributes.getValue("key");
        Url url = new Url(key);
        if (domain != null) {
            url.setDomain(domain);
        }
        if (name != null) {
            url.setName(name);
        }
        if (logview != null) {
            url.setLogview(logview);
        }
        if (count != null) {
            url.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        return url;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

