/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heavy.transform;

import com.dianping.cat.home.heavy.IEntity;
import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;
import com.dianping.cat.home.heavy.transform.DefaultLinker;
import com.dianping.cat.home.heavy.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static HeavyReport parse(InputStream in) throws SAXException, IOException {
        return (HeavyReport)DefaultSaxParser.parseEntity(HeavyReport.class, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static HeavyReport parse(Reader reader) throws SAXException, IOException {
        return (HeavyReport)DefaultSaxParser.parseEntity(HeavyReport.class, (InputSource)new InputSource((Reader)DefaultSaxParser.removeBOM((Object)reader)));
    }

    public static HeavyReport parse(String xml) throws SAXException, IOException {
        return (HeavyReport)DefaultSaxParser.parseEntity(HeavyReport.class, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForHeavyCache(HeavyCache parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("url".equals(qName)) {
            Url url = this.m_maker.buildUrl(attributes);
            this.m_linker.onUrl(parentObj, url);
            this.m_objs.push(url);
        } else if ("service".equals(qName)) {
            Service service = this.m_maker.buildService(attributes);
            this.m_linker.onService(parentObj, service);
            this.m_objs.push(service);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under heavy-cache!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForHeavyCall(HeavyCall parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("url".equals(qName)) {
            Url url = this.m_maker.buildUrl(attributes);
            this.m_linker.onUrl(parentObj, url);
            this.m_objs.push(url);
        } else if ("service".equals(qName)) {
            Service service = this.m_maker.buildService(attributes);
            this.m_linker.onService(parentObj, service);
            this.m_objs.push(service);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under heavy-call!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForHeavyReport(HeavyReport parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("heavy-sql".equals(qName)) {
            HeavySql heavySql = this.m_maker.buildHeavySql(attributes);
            this.m_linker.onHeavySql(parentObj, heavySql);
            this.m_objs.push(heavySql);
        } else if ("heavy-call".equals(qName)) {
            HeavyCall heavyCall = this.m_maker.buildHeavyCall(attributes);
            this.m_linker.onHeavyCall(parentObj, heavyCall);
            this.m_objs.push(heavyCall);
        } else if ("heavy-cache".equals(qName)) {
            HeavyCache heavyCache = this.m_maker.buildHeavyCache(attributes);
            this.m_linker.onHeavyCache(parentObj, heavyCache);
            this.m_objs.push(heavyCache);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under heavy-report!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForHeavySql(HeavySql parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("url".equals(qName)) {
            Url url = this.m_maker.buildUrl(attributes);
            this.m_linker.onUrl(parentObj, url);
            this.m_objs.push(url);
        } else if ("service".equals(qName)) {
            Service service = this.m_maker.buildService(attributes);
            this.m_linker.onService(parentObj, service);
            this.m_objs.push(service);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under heavy-sql!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForService(Service parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForUrl(Url parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("heavy-report".equals(qName)) {
            HeavyReport heavyReport = this.m_maker.buildHeavyReport(attributes);
            this.m_entity = heavyReport;
            this.m_objs.push(heavyReport);
            this.m_tags.push(qName);
        } else if ("heavy-sql".equals(qName)) {
            HeavySql heavySql = this.m_maker.buildHeavySql(attributes);
            this.m_entity = heavySql;
            this.m_objs.push(heavySql);
            this.m_tags.push(qName);
        } else if ("url".equals(qName)) {
            Url url = this.m_maker.buildUrl(attributes);
            this.m_entity = url;
            this.m_objs.push(url);
            this.m_tags.push(qName);
        } else if ("service".equals(qName)) {
            Service service = this.m_maker.buildService(attributes);
            this.m_entity = service;
            this.m_objs.push(service);
            this.m_tags.push(qName);
        } else if ("heavy-call".equals(qName)) {
            HeavyCall heavyCall = this.m_maker.buildHeavyCall(attributes);
            this.m_entity = heavyCall;
            this.m_objs.push(heavyCall);
            this.m_tags.push(qName);
        } else if ("heavy-cache".equals(qName)) {
            HeavyCache heavyCache = this.m_maker.buildHeavyCache(attributes);
            this.m_entity = heavyCache;
            this.m_objs.push(heavyCache);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof HeavyReport) {
                this.parseForHeavyReport((HeavyReport)parent, tag, qName, attributes);
            } else if (parent instanceof HeavySql) {
                this.parseForHeavySql((HeavySql)parent, tag, qName, attributes);
            } else if (parent instanceof Url) {
                this.parseForUrl((Url)parent, tag, qName, attributes);
            } else if (parent instanceof Service) {
                this.parseForService((Service)parent, tag, qName, attributes);
            } else if (parent instanceof HeavyCall) {
                this.parseForHeavyCall((HeavyCall)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof HeavyCache)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForHeavyCache((HeavyCache)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }

    protected Date toDate(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

