/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.entity;

import com.dianping.cat.home.router.BaseEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.Network;
import java.util.LinkedHashMap;
import java.util.Map;

public class NetworkPolicy
extends BaseEntity<NetworkPolicy> {
    private String m_id;
    private String m_title;
    private boolean m_block = false;
    private String m_serverGroup;
    private Map<String, Network> m_networks = new LinkedHashMap();

    public NetworkPolicy() {
    }

    public NetworkPolicy(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitNetworkPolicy(this);
    }

    public NetworkPolicy addNetwork(Network network) {
        this.m_networks.put(network.getId(), network);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkPolicy) {
            NetworkPolicy _o = (NetworkPolicy)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Network findNetwork(String id) {
        return (Network)this.m_networks.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Network findOrCreateNetwork(String id) {
        Network network = (Network)this.m_networks.get(id);
        if (network == null) {
            Map map = this.m_networks;
            synchronized (map) {
                network = (Network)this.m_networks.get(id);
                if (network == null) {
                    network = new Network(id);
                    this.m_networks.put(id, network);
                }
            }
        }
        return network;
    }

    public boolean getBlock() {
        return this.m_block;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Network> getNetworks() {
        return this.m_networks;
    }

    public String getServerGroup() {
        return this.m_serverGroup;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public boolean isBlock() {
        return this.m_block;
    }

    public void mergeAttributes(NetworkPolicy other) {
        this.assertAttributeEquals((Object)other, "network-policy", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getTitle() != null) {
            this.m_title = other.getTitle();
        }
        this.m_block = other.getBlock();
        if (other.getServerGroup() != null) {
            this.m_serverGroup = other.getServerGroup();
        }
    }

    public Network removeNetwork(String id) {
        return (Network)this.m_networks.remove(id);
    }

    public NetworkPolicy setBlock(boolean block) {
        this.m_block = block;
        return this;
    }

    public NetworkPolicy setId(String id) {
        this.m_id = id;
        return this;
    }

    public NetworkPolicy setServerGroup(String serverGroup) {
        this.m_serverGroup = serverGroup;
        return this;
    }

    public NetworkPolicy setTitle(String title) {
        this.m_title = title;
        return this;
    }
}

