/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.entity;

import com.dianping.cat.home.router.BaseEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.ServerGroup;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class RouterConfig
extends BaseEntity<RouterConfig> {
    private String m_backupServer;
    private int m_backupServerPort;
    private Map<String, DefaultServer> m_defaultServers = new LinkedHashMap();
    private Map<String, NetworkPolicy> m_networkPolicies = new LinkedHashMap();
    private Map<String, ServerGroup> m_serverGroups = new LinkedHashMap();
    private Map<String, Domain> m_domains = new LinkedHashMap();
    private Date m_startTime;
    private String m_domain;
    private Date m_endTime;

    public RouterConfig() {
    }

    public RouterConfig(String domain) {
        this.m_domain = domain;
    }

    public void accept(IVisitor visitor) {
        visitor.visitRouterConfig(this);
    }

    public RouterConfig addDefaultServer(DefaultServer defaultServer) {
        this.m_defaultServers.put(defaultServer.getId(), defaultServer);
        return this;
    }

    public RouterConfig addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public RouterConfig addNetworkPolicy(NetworkPolicy networkPolicy) {
        this.m_networkPolicies.put(networkPolicy.getId(), networkPolicy);
        return this;
    }

    public RouterConfig addServerGroup(ServerGroup serverGroup) {
        this.m_serverGroups.put(serverGroup.getId(), serverGroup);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouterConfig) {
            RouterConfig _o = (RouterConfig)obj;
            return this.equals((Object)this.getDomain(), (Object)_o.getDomain());
        }
        return false;
    }

    public DefaultServer findDefaultServer(String id) {
        return (DefaultServer)this.m_defaultServers.get(id);
    }

    public Domain findDomain(String id) {
        return (Domain)this.m_domains.get(id);
    }

    public NetworkPolicy findNetworkPolicy(String id) {
        return (NetworkPolicy)this.m_networkPolicies.get(id);
    }

    public ServerGroup findServerGroup(String id) {
        return (ServerGroup)this.m_serverGroups.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain findOrCreateDomain(String id) {
        Domain domain = (Domain)this.m_domains.get(id);
        if (domain == null) {
            Map map = this.m_domains;
            synchronized (map) {
                domain = (Domain)this.m_domains.get(id);
                if (domain == null) {
                    domain = new Domain(id);
                    this.m_domains.put(id, domain);
                }
            }
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkPolicy findOrCreateNetworkPolicy(String id) {
        NetworkPolicy networkPolicy = (NetworkPolicy)this.m_networkPolicies.get(id);
        if (networkPolicy == null) {
            Map map = this.m_networkPolicies;
            synchronized (map) {
                networkPolicy = (NetworkPolicy)this.m_networkPolicies.get(id);
                if (networkPolicy == null) {
                    networkPolicy = new NetworkPolicy(id);
                    this.m_networkPolicies.put(id, networkPolicy);
                }
            }
        }
        return networkPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGroup findOrCreateServerGroup(String id) {
        ServerGroup serverGroup = (ServerGroup)this.m_serverGroups.get(id);
        if (serverGroup == null) {
            Map map = this.m_serverGroups;
            synchronized (map) {
                serverGroup = (ServerGroup)this.m_serverGroups.get(id);
                if (serverGroup == null) {
                    serverGroup = new ServerGroup(id);
                    this.m_serverGroups.put(id, serverGroup);
                }
            }
        }
        return serverGroup;
    }

    public String getBackupServer() {
        return this.m_backupServer;
    }

    public int getBackupServerPort() {
        return this.m_backupServerPort;
    }

    public Map<String, DefaultServer> getDefaultServers() {
        return this.m_defaultServers;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public Map<String, NetworkPolicy> getNetworkPolicies() {
        return this.m_networkPolicies;
    }

    public Map<String, ServerGroup> getServerGroups() {
        return this.m_serverGroups;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        return hash;
    }

    public void mergeAttributes(RouterConfig other) {
        this.assertAttributeEquals((Object)other, "router-config", "domain", (Object)this.m_domain, (Object)other.getDomain());
        if (other.getBackupServer() != null) {
            this.m_backupServer = other.getBackupServer();
        }
        this.m_backupServerPort = other.getBackupServerPort();
        if (other.getStartTime() != null) {
            this.m_startTime = other.getStartTime();
        }
        if (other.getEndTime() != null) {
            this.m_endTime = other.getEndTime();
        }
    }

    public DefaultServer removeDefaultServer(String id) {
        return (DefaultServer)this.m_defaultServers.remove(id);
    }

    public Domain removeDomain(String id) {
        return (Domain)this.m_domains.remove(id);
    }

    public NetworkPolicy removeNetworkPolicy(String id) {
        return (NetworkPolicy)this.m_networkPolicies.remove(id);
    }

    public ServerGroup removeServerGroup(String id) {
        return (ServerGroup)this.m_serverGroups.remove(id);
    }

    public RouterConfig setBackupServer(String backupServer) {
        this.m_backupServer = backupServer;
        return this;
    }

    public RouterConfig setBackupServerPort(int backupServerPort) {
        this.m_backupServerPort = backupServerPort;
        return this;
    }

    public RouterConfig setDomain(String domain) {
        this.m_domain = domain;
        return this;
    }

    public RouterConfig setEndTime(Date endTime) {
        this.m_endTime = endTime;
        return this;
    }

    public RouterConfig setStartTime(Date startTime) {
        this.m_startTime = startTime;
        return this;
    }
}

