/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.Network;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;

public abstract class BaseVisitor
implements IVisitor {
    public void visitDefaultServer(DefaultServer defaultServer) {
    }

    public void visitDomain(Domain domain) {
        for (Group group : domain.getGroups().values()) {
            this.visitGroup(group);
        }
    }

    public void visitGroup(Group group) {
        for (Server server : group.getServers()) {
            this.visitServer(server);
        }
    }

    public void visitGroupServer(GroupServer groupServer) {
    }

    public void visitNetwork(Network network) {
    }

    public void visitNetworkPolicy(NetworkPolicy networkPolicy) {
        for (Network network : networkPolicy.getNetworks().values()) {
            this.visitNetwork(network);
        }
    }

    public void visitRouterConfig(RouterConfig routerConfig) {
        for (DefaultServer defaultServer : routerConfig.getDefaultServers().values()) {
            this.visitDefaultServer(defaultServer);
        }
        for (NetworkPolicy networkPolicy : routerConfig.getNetworkPolicies().values()) {
            this.visitNetworkPolicy(networkPolicy);
        }
        for (ServerGroup serverGroup : routerConfig.getServerGroups().values()) {
            this.visitServerGroup(serverGroup);
        }
        for (Domain domain : routerConfig.getDomains().values()) {
            this.visitDomain(domain);
        }
    }

    public void visitServer(Server server) {
    }

    public void visitServerGroup(ServerGroup serverGroup) {
        for (GroupServer groupServer : serverGroup.getGroupServers().values()) {
            this.visitGroupServer(groupServer);
        }
    }
}

