/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.Network;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(RouterConfig routerConfig) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((RouterConfig)routerConfig, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(RouterConfig routerConfig, OutputStream out) {
        routerConfig.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitDefaultServer(DefaultServer defaultServer) {
        if (defaultServer.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(defaultServer.getId());
        }
        this.writeTag(2, 0);
        this.writeDouble(defaultServer.getWeight());
        this.writeTag(3, 0);
        this.writeInt(defaultServer.getPort());
        this.writeTag(4, 0);
        this.writeBoolean(defaultServer.getEnable());
        this.writeTag(63, 3);
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        if (!domain.getGroups().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getGroups().size());
            for (Group group : domain.getGroups().values()) {
                group.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitGroup(Group group) {
        if (group.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(group.getId());
        }
        if (!group.getServers().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(group.getServers().size());
            for (Server server : group.getServers()) {
                server.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitGroupServer(GroupServer groupServer) {
        if (groupServer.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(groupServer.getId());
        }
        this.writeTag(63, 3);
    }

    public void visitNetwork(Network network) {
        if (network.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(network.getId());
        }
        this.writeTag(63, 3);
    }

    public void visitNetworkPolicy(NetworkPolicy networkPolicy) {
        if (networkPolicy.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(networkPolicy.getId());
        }
        if (networkPolicy.getTitle() != null) {
            this.writeTag(2, 1);
            this.writeString(networkPolicy.getTitle());
        }
        this.writeTag(3, 0);
        this.writeBoolean(networkPolicy.getBlock());
        if (networkPolicy.getServerGroup() != null) {
            this.writeTag(4, 1);
            this.writeString(networkPolicy.getServerGroup());
        }
        if (!networkPolicy.getNetworks().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(networkPolicy.getNetworks().size());
            for (Network network : networkPolicy.getNetworks().values()) {
                network.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitRouterConfig(RouterConfig routerConfig) {
        this.writeTag(63, 0);
        if (routerConfig.getBackupServer() != null) {
            this.writeTag(1, 1);
            this.writeString(routerConfig.getBackupServer());
        }
        this.writeTag(2, 0);
        this.writeInt(routerConfig.getBackupServerPort());
        if (routerConfig.getStartTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(routerConfig.getStartTime());
        }
        if (routerConfig.getDomain() != null) {
            this.writeTag(4, 1);
            this.writeString(routerConfig.getDomain());
        }
        if (routerConfig.getEndTime() != null) {
            this.writeTag(5, 1);
            this.writeDate(routerConfig.getEndTime());
        }
        if (!routerConfig.getDefaultServers().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(routerConfig.getDefaultServers().size());
            for (DefaultServer defaultServer : routerConfig.getDefaultServers().values()) {
                defaultServer.accept(this.m_visitor);
            }
        }
        if (!routerConfig.getNetworkPolicies().isEmpty()) {
            this.writeTag(34, 2);
            this.writeInt(routerConfig.getNetworkPolicies().size());
            for (NetworkPolicy networkPolicy : routerConfig.getNetworkPolicies().values()) {
                networkPolicy.accept(this.m_visitor);
            }
        }
        if (!routerConfig.getServerGroups().isEmpty()) {
            this.writeTag(35, 2);
            this.writeInt(routerConfig.getServerGroups().size());
            for (ServerGroup serverGroup : routerConfig.getServerGroups().values()) {
                serverGroup.accept(this.m_visitor);
            }
        }
        if (!routerConfig.getDomains().isEmpty()) {
            this.writeTag(36, 2);
            this.writeInt(routerConfig.getDomains().size());
            for (Domain domain : routerConfig.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitServer(Server server) {
        if (server.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(server.getId());
        }
        this.writeTag(2, 0);
        this.writeInt(server.getPort());
        this.writeTag(3, 0);
        this.writeDouble(server.getWeight());
        this.writeTag(63, 3);
    }

    public void visitServerGroup(ServerGroup serverGroup) {
        if (serverGroup.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(serverGroup.getId());
        }
        if (serverGroup.getTitle() != null) {
            this.writeTag(2, 1);
            this.writeString(serverGroup.getTitle());
        }
        if (!serverGroup.getGroupServers().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(serverGroup.getGroupServers().size());
            for (GroupServer groupServer : serverGroup.getGroupServers().values()) {
                groupServer.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeBoolean(boolean value) {
        try {
            this.m_out.writeByte(value ? 1 : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

