/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.Network;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;
import com.dianping.cat.home.router.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    public DefaultServer buildDefaultServer(Attributes attributes) {
        String id = attributes.getValue("id");
        String weight = attributes.getValue("weight");
        String port = attributes.getValue("port");
        String enable = attributes.getValue("enable");
        DefaultServer defaultServer = new DefaultServer(id);
        if (weight != null) {
            defaultServer.setWeight(((Double)this.convert(Double.class, weight, (Object)0.0)).doubleValue());
        }
        if (port != null) {
            defaultServer.setPort(((Integer)this.convert(Integer.class, port, (Object)0)).intValue());
        }
        if (enable != null) {
            defaultServer.setEnable(((Boolean)this.convert(Boolean.class, enable, (Object)false)).booleanValue());
        }
        return defaultServer;
    }

    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        Domain domain = new Domain(id);
        return domain;
    }

    public Group buildGroup(Attributes attributes) {
        String id = attributes.getValue("id");
        Group group = new Group(id);
        return group;
    }

    public GroupServer buildGroupServer(Attributes attributes) {
        String id = attributes.getValue("id");
        GroupServer groupServer = new GroupServer(id);
        return groupServer;
    }

    public Network buildNetwork(Attributes attributes) {
        String id = attributes.getValue("id");
        Network network = new Network(id);
        return network;
    }

    public NetworkPolicy buildNetworkPolicy(Attributes attributes) {
        String id = attributes.getValue("id");
        String title = attributes.getValue("title");
        String block = attributes.getValue("block");
        String serverGroup = attributes.getValue("server-group");
        NetworkPolicy networkPolicy = new NetworkPolicy(id);
        if (title != null) {
            networkPolicy.setTitle(title);
        }
        if (block != null) {
            networkPolicy.setBlock(((Boolean)this.convert(Boolean.class, block, (Object)false)).booleanValue());
        }
        if (serverGroup != null) {
            networkPolicy.setServerGroup(serverGroup);
        }
        return networkPolicy;
    }

    public RouterConfig buildRouterConfig(Attributes attributes) {
        String backupServer = attributes.getValue("backup-server");
        String backupServerPort = attributes.getValue("backup-server-port");
        String startTime = attributes.getValue("startTime");
        String domain = attributes.getValue("domain");
        String endTime = attributes.getValue("endTime");
        RouterConfig routerConfig = new RouterConfig(domain);
        if (backupServer != null) {
            routerConfig.setBackupServer(backupServer);
        }
        if (backupServerPort != null) {
            routerConfig.setBackupServerPort(((Integer)this.convert(Integer.class, backupServerPort, (Object)0)).intValue());
        }
        if (startTime != null) {
            routerConfig.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            routerConfig.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return routerConfig;
    }

    public Server buildServer(Attributes attributes) {
        String id = attributes.getValue("id");
        String port = attributes.getValue("port");
        String weight = attributes.getValue("weight");
        Server server = new Server();
        if (id != null) {
            server.setId(id);
        }
        if (port != null) {
            server.setPort(((Integer)this.convert(Integer.class, port, (Object)0)).intValue());
        }
        if (weight != null) {
            server.setWeight(((Double)this.convert(Double.class, weight, (Object)0.0)).doubleValue());
        }
        return server;
    }

    public ServerGroup buildServerGroup(Attributes attributes) {
        String id = attributes.getValue("id");
        String title = attributes.getValue("title");
        ServerGroup serverGroup = new ServerGroup(id);
        if (title != null) {
            serverGroup.setTitle(title);
        }
        return serverGroup;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

