/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.server.transform;

import com.dianping.cat.home.server.IEntity;
import com.dianping.cat.home.server.IVisitor;
import com.dianping.cat.home.server.entity.Group;
import com.dianping.cat.home.server.entity.Item;
import com.dianping.cat.home.server.entity.Segment;
import com.dianping.cat.home.server.entity.ServerMetricConfig;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private ServerMetricConfig m_serverMetricConfig;

    public DefaultMerger() {
    }

    public DefaultMerger(ServerMetricConfig serverMetricConfig) {
        this.m_serverMetricConfig = serverMetricConfig;
        this.m_objs.push(serverMetricConfig);
    }

    public ServerMetricConfig getServerMetricConfig() {
        return this.m_serverMetricConfig;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeGroup(Group to, Group from) {
        to.mergeAttributes(from);
    }

    protected void mergeItem(Item to, Item from) {
        to.mergeAttributes(from);
    }

    protected void mergeSegment(Segment to, Segment from) {
        to.mergeAttributes(from);
    }

    protected void mergeServerMetricConfig(ServerMetricConfig to, ServerMetricConfig from) {
        to.mergeAttributes(from);
    }

    public void visitGroup(Group from) {
        Group to = (Group)this.m_objs.peek();
        this.mergeGroup(to, from);
        this.visitGroupChildren(to, from);
    }

    protected void visitGroupChildren(Group to, Group from) {
        for (Item source : from.getItems().values()) {
            Item target = to.findItem(source.getId());
            if (target == null) {
                target = new Item(source.getId());
                to.addItem(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitItem(Item from) {
        Item to = (Item)this.m_objs.peek();
        this.mergeItem(to, from);
        this.visitItemChildren(to, from);
    }

    protected void visitItemChildren(Item to, Item from) {
        for (Segment source : from.getSegments().values()) {
            Segment target = to.findSegment(source.getId());
            if (target == null) {
                target = new Segment(source.getId());
                to.addSegment(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitSegment(Segment from) {
        Segment to = (Segment)this.m_objs.peek();
        this.mergeSegment(to, from);
        this.visitSegmentChildren(to, from);
    }

    protected void visitSegmentChildren(Segment to, Segment from) {
    }

    public void visitServerMetricConfig(ServerMetricConfig from) {
        ServerMetricConfig to = (ServerMetricConfig)this.m_objs.peek();
        this.mergeServerMetricConfig(to, from);
        this.visitServerMetricConfigChildren(to, from);
    }

    protected void visitServerMetricConfigChildren(ServerMetricConfig to, ServerMetricConfig from) {
        for (Group source : from.getGroups().values()) {
            Group target = to.findGroup(source.getId());
            if (target == null) {
                target = new Group(source.getId());
                to.addGroup(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

