/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.transform;

import com.dianping.cat.home.service.client.IEntity;
import com.dianping.cat.home.service.client.IVisitor;
import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.entity.Domain;
import com.dianping.cat.home.service.client.entity.Method;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private ClientReport m_clientReport;

    public DefaultMerger() {
    }

    public DefaultMerger(ClientReport clientReport) {
        this.m_clientReport = clientReport;
        this.m_objs.push(clientReport);
    }

    public ClientReport getClientReport() {
        return this.m_clientReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeClientReport(ClientReport to, ClientReport from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeMethod(Method to, Method from) {
        to.mergeAttributes(from);
    }

    public void visitClientReport(ClientReport from) {
        ClientReport to = (ClientReport)this.m_objs.peek();
        this.mergeClientReport(to, from);
        this.visitClientReportChildren(to, from);
    }

    protected void visitClientReportChildren(ClientReport to, ClientReport from) {
        for (Domain source : from.getDomains().values()) {
            Domain target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        for (Method source : from.getMethods().values()) {
            Method target = to.findMethod(source.getId());
            if (target == null) {
                target = new Method(source.getId());
                to.addMethod(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitMethod(Method from) {
        Method to = (Method)this.m_objs.peek();
        this.mergeMethod(to, from);
        this.visitMethodChildren(to, from);
    }

    protected void visitMethodChildren(Method to, Method from) {
    }
}

