/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.transform;

import com.dianping.cat.home.service.client.IVisitor;
import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.entity.Domain;
import com.dianping.cat.home.service.client.entity.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(ClientReport clientReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((ClientReport)clientReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(ClientReport clientReport, OutputStream out) {
        clientReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitClientReport(ClientReport clientReport) {
        this.writeTag(63, 0);
        if (clientReport.getDomain() != null) {
            this.writeTag(1, 1);
            this.writeString(clientReport.getDomain());
        }
        if (clientReport.getStartTime() != null) {
            this.writeTag(2, 1);
            this.writeDate(clientReport.getStartTime());
        }
        if (clientReport.getEndTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(clientReport.getEndTime());
        }
        if (!clientReport.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(clientReport.getDomains().size());
            for (Domain domain : clientReport.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        this.writeTag(2, 0);
        this.writeLong(domain.getTotalCount());
        this.writeTag(3, 0);
        this.writeLong(domain.getFailureCount());
        this.writeTag(4, 0);
        this.writeDouble(domain.getFailurePercent());
        this.writeTag(5, 0);
        this.writeDouble(domain.getSum());
        this.writeTag(6, 0);
        this.writeDouble(domain.getAvg());
        if (!domain.getMethods().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getMethods().size());
            for (Method method : domain.getMethods().values()) {
                method.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitMethod(Method method) {
        if (method.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(method.getId());
        }
        if (method.getService() != null) {
            this.writeTag(2, 1);
            this.writeString(method.getService());
        }
        this.writeTag(3, 0);
        this.writeLong(method.getTotalCount());
        this.writeTag(4, 0);
        this.writeLong(method.getFailureCount());
        this.writeTag(5, 0);
        this.writeDouble(method.getFailurePercent());
        this.writeTag(6, 0);
        this.writeDouble(method.getSum());
        this.writeTag(7, 0);
        this.writeDouble(method.getAvg());
        this.writeTag(8, 0);
        this.writeDouble(method.getQps());
        this.writeTag(9, 0);
        this.writeDouble(method.getTimeout());
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLong(long value) {
        try {
            this.writeVarint(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

