/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.transform;

import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.entity.Domain;
import com.dianping.cat.home.service.client.entity.Method;
import com.dianping.cat.home.service.client.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    public ClientReport buildClientReport(Attributes attributes) {
        String domain = attributes.getValue("domain");
        String startTime = attributes.getValue("start-time");
        String endTime = attributes.getValue("end-time");
        ClientReport clientReport = new ClientReport(domain);
        if (startTime != null) {
            clientReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            clientReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return clientReport;
    }

    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        String totalCount = attributes.getValue("totalCount");
        String failureCount = attributes.getValue("failureCount");
        String failurePercent = attributes.getValue("failurePercent");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        Domain domain = new Domain(id);
        if (totalCount != null) {
            domain.setTotalCount(((Long)this.convert(Long.class, totalCount, (Object)0L)).longValue());
        }
        if (failureCount != null) {
            domain.setFailureCount(((Long)this.convert(Long.class, failureCount, (Object)0L)).longValue());
        }
        if (failurePercent != null) {
            domain.setFailurePercent(((Double)this.convert(Double.class, failurePercent, (Object)0.0)).doubleValue());
        }
        if (sum != null) {
            domain.setSum(((Double)this.convert(Double.class, sum, (Object)0.0)).doubleValue());
        }
        if (avg != null) {
            domain.setAvg(((Double)this.convert(Double.class, avg, (Object)0.0)).doubleValue());
        }
        return domain;
    }

    public Method buildMethod(Attributes attributes) {
        String id = attributes.getValue("id");
        String service = attributes.getValue("service");
        String totalCount = attributes.getValue("totalCount");
        String failureCount = attributes.getValue("failureCount");
        String failurePercent = attributes.getValue("failurePercent");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        String qps = attributes.getValue("qps");
        String timeout = attributes.getValue("timeout");
        Method method = new Method(id);
        if (service != null) {
            method.setService(service);
        }
        if (totalCount != null) {
            method.setTotalCount(((Long)this.convert(Long.class, totalCount, (Object)0L)).longValue());
        }
        if (failureCount != null) {
            method.setFailureCount(((Long)this.convert(Long.class, failureCount, (Object)0L)).longValue());
        }
        if (failurePercent != null) {
            method.setFailurePercent(((Double)this.convert(Double.class, failurePercent, (Object)0.0)).doubleValue());
        }
        if (sum != null) {
            method.setSum(((Double)this.convert(Double.class, sum, (Object)0.0)).doubleValue());
        }
        if (avg != null) {
            method.setAvg(((Double)this.convert(Double.class, avg, (Object)0.0)).doubleValue());
        }
        if (qps != null) {
            method.setQps(((Double)this.convert(Double.class, qps, (Object)0.0)).doubleValue());
        }
        if (timeout != null) {
            method.setTimeout(((Double)this.convert(Double.class, timeout, (Object)0.0)).doubleValue());
        }
        return method;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

