/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.transform;

import com.dianping.cat.home.service.entity.Domain;
import com.dianping.cat.home.service.entity.ServiceReport;
import com.dianping.cat.home.service.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        Domain domain = new Domain(id);
        return domain;
    }

    public ServiceReport buildServiceReport(Attributes attributes) {
        String startTime = attributes.getValue("startTime");
        String domain = attributes.getValue("domain");
        String endTime = attributes.getValue("endTime");
        ServiceReport serviceReport = new ServiceReport(domain);
        if (startTime != null) {
            serviceReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            serviceReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return serviceReport;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

