/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.alert.entity;

import com.dianping.cat.home.storage.alert.BaseEntity;
import com.dianping.cat.home.storage.alert.IVisitor;
import com.dianping.cat.home.storage.alert.entity.Operation;
import java.util.LinkedHashMap;
import java.util.Map;

public class Machine
extends BaseEntity<Machine> {
    private String m_id;
    private int m_level;
    private int m_count;
    private Map<String, Operation> m_operations = new LinkedHashMap();

    public Machine() {
    }

    public Machine(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitMachine(this);
    }

    public Machine addOperation(Operation operation) {
        this.m_operations.put(operation.getId(), operation);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Machine) {
            Machine _o = (Machine)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Operation findOperation(String id) {
        return (Operation)this.m_operations.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation findOrCreateOperation(String id) {
        Operation operation = (Operation)this.m_operations.get(id);
        if (operation == null) {
            Map map = this.m_operations;
            synchronized (map) {
                operation = (Operation)this.m_operations.get(id);
                if (operation == null) {
                    operation = new Operation(id);
                    this.m_operations.put(id, operation);
                }
            }
        }
        return operation;
    }

    public int getCount() {
        return this.m_count;
    }

    public String getId() {
        return this.m_id;
    }

    public int getLevel() {
        return this.m_level;
    }

    public Map<String, Operation> getOperations() {
        return this.m_operations;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public Machine incCount() {
        ++this.m_count;
        return this;
    }

    public Machine incCount(int count) {
        this.m_count += count;
        return this;
    }

    public void mergeAttributes(Machine other) {
        this.assertAttributeEquals((Object)other, "machine", "id", (Object)this.m_id, (Object)other.getId());
        this.m_level = other.getLevel();
        this.m_count = other.getCount();
    }

    public Operation removeOperation(String id) {
        return (Operation)this.m_operations.remove(id);
    }

    public Machine setCount(int count) {
        this.m_count = count;
        return this;
    }

    public Machine setId(String id) {
        this.m_id = id;
        return this;
    }

    public Machine setLevel(int level) {
        this.m_level = level;
        return this;
    }
}

