/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.alert.entity;

import com.dianping.cat.home.storage.alert.BaseEntity;
import com.dianping.cat.home.storage.alert.IVisitor;
import com.dianping.cat.home.storage.alert.entity.Target;
import java.util.LinkedHashMap;
import java.util.Map;

public class Operation
extends BaseEntity<Operation> {
    private String m_id;
    private int m_level;
    private int m_count;
    private Map<String, Target> m_targets = new LinkedHashMap();

    public Operation() {
    }

    public Operation(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitOperation(this);
    }

    public Operation addTarget(Target target) {
        this.m_targets.put(target.getId(), target);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Operation) {
            Operation _o = (Operation)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Target findTarget(String id) {
        return (Target)this.m_targets.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target findOrCreateTarget(String id) {
        Target target = (Target)this.m_targets.get(id);
        if (target == null) {
            Map map = this.m_targets;
            synchronized (map) {
                target = (Target)this.m_targets.get(id);
                if (target == null) {
                    target = new Target(id);
                    this.m_targets.put(id, target);
                }
            }
        }
        return target;
    }

    public int getCount() {
        return this.m_count;
    }

    public String getId() {
        return this.m_id;
    }

    public int getLevel() {
        return this.m_level;
    }

    public Map<String, Target> getTargets() {
        return this.m_targets;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public Operation incCount() {
        ++this.m_count;
        return this;
    }

    public Operation incCount(int count) {
        this.m_count += count;
        return this;
    }

    public void mergeAttributes(Operation other) {
        this.assertAttributeEquals((Object)other, "operation", "id", (Object)this.m_id, (Object)other.getId());
        this.m_level = other.getLevel();
        this.m_count = other.getCount();
    }

    public Target removeTarget(String id) {
        return (Target)this.m_targets.remove(id);
    }

    public Operation setCount(int count) {
        this.m_count = count;
        return this;
    }

    public Operation setId(String id) {
        this.m_id = id;
        return this;
    }

    public Operation setLevel(int level) {
        this.m_level = level;
        return this;
    }
}

