/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.alert.entity;

import com.dianping.cat.home.storage.alert.BaseEntity;
import com.dianping.cat.home.storage.alert.IVisitor;
import com.dianping.cat.home.storage.alert.entity.Storage;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class StorageAlertInfo
extends BaseEntity<StorageAlertInfo> {
    private String m_id;
    private Date m_startTime;
    private Date m_endTime;
    private Map<String, Storage> m_storages = new LinkedHashMap();

    public StorageAlertInfo() {
    }

    public StorageAlertInfo(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitStorageAlertInfo(this);
    }

    public StorageAlertInfo addStorage(Storage storage) {
        this.m_storages.put(storage.getId(), storage);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageAlertInfo) {
            StorageAlertInfo _o = (StorageAlertInfo)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Storage findStorage(String id) {
        return (Storage)this.m_storages.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage findOrCreateStorage(String id) {
        Storage storage = (Storage)this.m_storages.get(id);
        if (storage == null) {
            Map map = this.m_storages;
            synchronized (map) {
                storage = (Storage)this.m_storages.get(id);
                if (storage == null) {
                    storage = new Storage(id);
                    this.m_storages.put(id, storage);
                }
            }
        }
        return storage;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public String getId() {
        return this.m_id;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public Map<String, Storage> getStorages() {
        return this.m_storages;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(StorageAlertInfo other) {
        this.assertAttributeEquals((Object)other, "storage-alert-info", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getStartTime() != null) {
            this.m_startTime = other.getStartTime();
        }
        if (other.getEndTime() != null) {
            this.m_endTime = other.getEndTime();
        }
    }

    public Storage removeStorage(String id) {
        return (Storage)this.m_storages.remove(id);
    }

    public StorageAlertInfo setEndTime(Date endTime) {
        this.m_endTime = endTime;
        return this;
    }

    public StorageAlertInfo setId(String id) {
        this.m_id = id;
        return this;
    }

    public StorageAlertInfo setStartTime(Date startTime) {
        this.m_startTime = startTime;
        return this;
    }
}

