/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.alert.transform;

import com.dianping.cat.home.storage.alert.IEntity;
import com.dianping.cat.home.storage.alert.IVisitor;
import com.dianping.cat.home.storage.alert.entity.Detail;
import com.dianping.cat.home.storage.alert.entity.Machine;
import com.dianping.cat.home.storage.alert.entity.Operation;
import com.dianping.cat.home.storage.alert.entity.Storage;
import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import com.dianping.cat.home.storage.alert.entity.Target;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = this.toString(value);
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape((Object)e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (Object item : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(value, i);
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    protected String toString(Date date, String format) {
        if (date != null) {
            return new SimpleDateFormat(format).format(date);
        }
        return null;
    }

    public void visitDetail(Detail detail) {
        this.startTag("detail", true, null, new Object[]{"content", detail.getContent(), "level", detail.getLevel()});
    }

    public void visitMachine(Machine machine) {
        this.startTag("machine", null, new Object[]{"id", machine.getId(), "level", machine.getLevel(), "count", machine.getCount()});
        if (!machine.getOperations().isEmpty()) {
            for (Operation operation : machine.getOperations().values()) {
                operation.accept(this.m_visitor);
            }
        }
        this.endTag("machine");
    }

    public void visitOperation(Operation operation) {
        this.startTag("operation", null, new Object[]{"id", operation.getId(), "level", operation.getLevel(), "count", operation.getCount()});
        if (!operation.getTargets().isEmpty()) {
            for (Target target : operation.getTargets().values()) {
                target.accept(this.m_visitor);
            }
        }
        this.endTag("operation");
    }

    public void visitStorage(Storage storage) {
        this.startTag("storage", null, new Object[]{"id", storage.getId(), "level", storage.getLevel(), "count", storage.getCount()});
        if (!storage.getMachines().isEmpty()) {
            for (Machine machine : storage.getMachines().values()) {
                machine.accept(this.m_visitor);
            }
        }
        this.endTag("storage");
    }

    public void visitStorageAlertInfo(StorageAlertInfo storageAlertInfo) {
        this.startTag("storage-alert-info", null, new Object[]{"id", storageAlertInfo.getId(), "start-time", this.toString(storageAlertInfo.getStartTime(), "yyyy-MM-dd HH:mm:ss"), "end-time", this.toString(storageAlertInfo.getEndTime(), "yyyy-MM-dd HH:mm:ss")});
        if (!storageAlertInfo.getStorages().isEmpty()) {
            for (Storage storage : storageAlertInfo.getStorages().values()) {
                storage.accept(this.m_visitor);
            }
        }
        this.endTag("storage-alert-info");
    }

    public void visitTarget(Target target) {
        this.startTag("target", null, new Object[]{"id", target.getId(), "title", target.getTitle(), "level", target.getLevel(), "count", target.getCount()});
        if (!target.getDetails().isEmpty()) {
            for (Detail detail : target.getDetails()) {
                detail.accept(this.m_visitor);
            }
        }
        this.endTag("target");
    }
}

