/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.alarm.spi.decorator.ProjectDecorator;
import com.dianping.cat.report.alert.summary.AlertSummaryExecutor;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Inject;

public class BusinessDecorator
extends ProjectDecorator
implements Initializable {
    public static final String ID = AlertType.Business.getName();
    public Configuration m_configuration;
    @Inject
    private AlertSummaryExecutor m_executor;

    public String generateContent(AlertEntity alert) {
        try {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("domain", alert.getDomain());
            dataMap.put("date", this.m_format.format(alert.getDate()));
            dataMap.put("mertic", alert.getMetric());
            String[] business = alert.getContent().split("<br/>");
            ArrayList<String> strs = new ArrayList<String>(Arrays.asList(business));
            dataMap.put("businessstr", strs);
            StringWriter sw = new StringWriter(5000);
            Template t = this.m_configuration.getTemplate("businessAlertMarkdown.ftl");
            t.process(dataMap, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return this.generateTitle(alert);
        }
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\u4e1a\u52a1\u544a\u8b66][\u9879\u76ee: ").append(alert.getDomain()).append("]");
        sb.append("[\u4e1a\u52a1\u6307\u6807: ").append(alert.getMetric()).append("][\u6ce2\u52a8\u5f02\u5e38]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

