/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.consumer.business.model.entity.BusinessItem;
import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.consumer.business.model.entity.Segment;
import com.dianping.cat.helper.MetricType;
import java.util.Map;

public class BusinessReportGroup {
    private BusinessReport m_last;
    private BusinessReport m_current;
    private boolean m_dataReady;

    public double[] extractData(int currentMinute, int ruleMinute, String key, MetricType type) {
        double[] value = new double[ruleMinute];
        if (currentMinute >= ruleMinute - 1) {
            int start = currentMinute + 1 - ruleMinute;
            int end = currentMinute;
            value = this.queryRealData(start, end, key, this.m_current, type);
        } else if (currentMinute < 0) {
            int start = 60 + currentMinute + 1 - ruleMinute;
            int end = 60 + currentMinute;
            value = this.queryRealData(start, end, key, this.m_last, type);
        } else {
            int currentStart = 0;
            int currentEnd = currentMinute;
            double[] currentValue = this.queryRealData(currentStart, currentEnd, key, this.m_current, type);
            int lastStart = 61 - (ruleMinute - currentMinute);
            int lastEnd = 59;
            double[] lastValue = this.queryRealData(lastStart, lastEnd, key, this.m_last, type);
            value = this.mergerArray(lastValue, currentValue);
        }
        return value;
    }

    public BusinessReport getCurrent() {
        return this.m_current;
    }

    public BusinessReportGroup setCurrent(BusinessReport current) {
        this.m_current = current;
        return this;
    }

    public BusinessReport getLast() {
        return this.m_last;
    }

    public BusinessReportGroup setLast(BusinessReport last) {
        this.m_last = last;
        return this;
    }

    public boolean isDataReady() {
        return this.m_dataReady;
    }

    public BusinessReportGroup setDataReady(boolean dataReady) {
        this.m_dataReady = dataReady;
        return this;
    }

    public double[] mergerArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    private double[] queryRealData(int start, int end, String key, BusinessReport report, MetricType type) {
        double[] all = new double[60];
        BusinessItem businessItems = report.findBusinessItem(key);
        if (businessItems != null) {
            Map map = businessItems.getSegments();
            for (Map.Entry entry : map.entrySet()) {
                Integer minute = (Integer)entry.getKey();
                Segment seg = (Segment)entry.getValue();
                if (type == MetricType.AVG) {
                    all[minute.intValue()] = seg.getAvg();
                    continue;
                }
                if (type == MetricType.COUNT) {
                    all[minute.intValue()] = seg.getCount();
                    continue;
                }
                if (type != MetricType.SUM) continue;
                all[minute.intValue()] = seg.getSum();
            }
        }
        int length = end - start + 1;
        double[] result = new double[length];
        System.arraycopy(all, start, result, 0, length);
        return result;
    }
}

