/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.report.alert.business.BusinessReportGroup;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class BusinessReportGroupService {
    @Inject(value={"business"})
    private ModelService<BusinessReport> m_service;

    private BusinessReport fetchMetricReport(String product, ModelPeriod period, int min, int max) {
        ModelRequest request = new ModelRequest(product, period.getStartTime()).setProperty("requireAll", "ture");
        request.setProperty("min", String.valueOf(min));
        request.setProperty("max", String.valueOf(max));
        ModelResponse response = this.m_service.invoke(request);
        if (response != null) {
            return (BusinessReport)response.getModel();
        }
        return null;
    }

    public BusinessReportGroup prepareDatas(String domain, int minute, int duration) {
        int min;
        BusinessReport currentReport = null;
        BusinessReport lastReport = null;
        boolean dataReady = false;
        if (minute >= duration - 1) {
            min = minute - duration + 1;
            int max = minute;
            currentReport = this.fetchMetricReport(domain, ModelPeriod.CURRENT, min, max);
            if (currentReport != null) {
                dataReady = true;
            }
        } else if (minute < 0) {
            min = minute + 60 - duration + 1;
            int max = minute + 60;
            lastReport = this.fetchMetricReport(domain, ModelPeriod.LAST, min, max);
            if (lastReport != null) {
                dataReady = true;
            }
        } else {
            int lastLength = duration - minute - 1;
            int lastMin = 60 - lastLength;
            currentReport = this.fetchMetricReport(domain, ModelPeriod.CURRENT, 0, minute);
            lastReport = this.fetchMetricReport(domain, ModelPeriod.LAST, lastMin, 59);
            if (lastReport != null && currentReport != null) {
                dataReady = true;
            }
        }
        BusinessReportGroup reports = new BusinessReportGroup();
        reports.setLast(lastReport).setCurrent(currentReport).setDataReady(dataReady);
        return reports;
    }
}

